/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.DsdChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.DsfChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FmtChunk {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.FmtChunk");
    public static final int FMT_CHUNK_MIN_DATA_SIZE_ = 40;
    private long chunkSizeLength;

    public static FmtChunk readChunkHeader(ByteBuffer dataBuffer) {
        String type = Utils.readFourBytesAsChars(dataBuffer);
        if (DsfChunkType.FORMAT.getCode().equals(type)) {
            return new FmtChunk(dataBuffer);
        }
        return null;
    }

    private FmtChunk(ByteBuffer dataBuffer) {
        this.chunkSizeLength = dataBuffer.getLong();
    }

    public GenericAudioHeader readChunkData(DsdChunk dsd, FileChannel fc) throws IOException {
        long sizeExcludingChunkHeader = this.chunkSizeLength - (long)(IffHeaderChunk.SIGNATURE_LENGTH + 8);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, (int)sizeExcludingChunkHeader);
        return this.readAudioInfo(dsd, audioData);
    }

    private GenericAudioHeader readAudioInfo(DsdChunk dsd, ByteBuffer audioInfoChunk) {
        GenericAudioHeader audioHeader = new GenericAudioHeader();
        if (audioInfoChunk.limit() < 40) {
            logger.log(Level.WARNING, "Not enough bytes supplied for Generic audio header. Returning an empty one.");
            return audioHeader;
        }
        audioInfoChunk.order(ByteOrder.LITTLE_ENDIAN);
        int version = audioInfoChunk.getInt();
        int formatId = audioInfoChunk.getInt();
        int channelType = audioInfoChunk.getInt();
        int channelNumber = audioInfoChunk.getInt();
        int samplingFreqency = audioInfoChunk.getInt();
        int bitsPerSample = audioInfoChunk.getInt();
        long sampleCount = audioInfoChunk.getLong();
        int blocksPerSample = audioInfoChunk.getInt();
        audioHeader.setEncodingType("DSF");
        audioHeader.setBitRate(bitsPerSample * samplingFreqency * channelNumber);
        audioHeader.setBitsPerSample(bitsPerSample);
        audioHeader.setChannelNumber(channelNumber);
        audioHeader.setSamplingRate(samplingFreqency);
        audioHeader.setNoOfSamples(sampleCount);
        audioHeader.setPreciseLength((float)sampleCount / (float)samplingFreqency);
        audioHeader.setVariableBitRate(false);
        logger.log(Level.FINE, "Created audio header: " + audioHeader);
        return audioHeader;
    }
}

