/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.DsdChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.ID3Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileWriter2;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DsfFileWriter
extends AudioFileWriter2 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writeTag(Tag tag, Path file) throws CannotWriteException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd == null) return;
            if (dsd.getMetadataOffset() > 0L) {
                fc.position(dsd.getMetadataOffset());
                ID3Chunk id3Chunk = ID3Chunk.readChunk(Utils.readFileDataIntoBufferLE(fc, (int)(fc.size() - fc.position())));
                if (id3Chunk == null) throw new CannotWriteException(file + "Could not find existing ID3v2 Tag");
                fc.position(dsd.getMetadataOffset());
                ByteBuffer bb = this.convert((AbstractID3v2Tag)tag);
                fc.write(bb);
                return;
            } else {
                fc.position(fc.size());
                dsd.setMetadataOffset(fc.size());
                ByteBuffer bb = this.convert((AbstractID3v2Tag)tag);
                fc.write(bb);
                dsd.setFileLength(fc.size());
                fc.position(0L);
                fc.write(dsd.write());
            }
            return;
        }
        catch (AccessDeniedException ade) {
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(ioe.getMessage());
        }
    }

    public ByteBuffer convert(AbstractID3v2Tag tag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long existingTagSize = tag.getSize();
            if (existingTagSize > 0L && Utils.isOddLength(existingTagSize)) {
                ++existingTagSize;
            }
            tag.write(baos, (int)existingTagSize);
            if ((baos.toByteArray().length & 1) != 0) {
                int newSize = baos.toByteArray().length + 1;
                baos = new ByteArrayOutputStream();
                tag.write(baos, newSize);
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    protected void deleteTag(Tag tag, Path file) throws CannotWriteException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd != null && dsd.getMetadataOffset() > 0L) {
                fc.position(dsd.getMetadataOffset());
                ID3Chunk id3Chunk = ID3Chunk.readChunk(Utils.readFileDataIntoBufferLE(fc, (int)(fc.size() - fc.position())));
                if (id3Chunk != null) {
                    fc.truncate(dsd.getMetadataOffset());
                    dsd.setMetadataOffset(0L);
                    dsd.setFileLength(fc.size());
                    fc.position(0L);
                    fc.write(dsd.write());
                }
            }
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }
}

