/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.DsdChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.FmtChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.ID3Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileReader2;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v23Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v24Tag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;

public class DsfFileReader
extends AudioFileReader2 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected GenericAudioHeader getEncodingInfo(Path file) throws CannotReadException, IOException {
        Throwable throwable = null;
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd == null) throw new CannotReadException(file + " Not a valid dsf file. Content does not start with 'DSD '");
            ByteBuffer fmtChunkBuffer = Utils.readFileDataIntoBufferLE(fc, IffHeaderChunk.SIGNATURE_LENGTH + 8);
            FmtChunk fmt = FmtChunk.readChunkHeader(fmtChunkBuffer);
            if (fmt != null) {
                GenericAudioHeader genericAudioHeader = fmt.readChunkData(dsd, fc);
                return genericAudioHeader;
            }
            try {
                throw new CannotReadException(file + " Not a valid dsf file. Content does not include 'fmt ' chunk");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    protected Tag getTag(Path file) throws CannotReadException, IOException {
        Throwable throwable = null;
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd != null) {
                Tag tag = this.readTag(fc, dsd, file.toString());
                return tag;
            }
            try {
                throw new CannotReadException(file + " Not a valid dsf file. Content does not start with 'DSD '.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Tag readTag(FileChannel fc, DsdChunk dsd, String fileName) throws CannotReadException, IOException {
        if (dsd.getMetadataOffset() > 0L) {
            fc.position(dsd.getMetadataOffset());
            ID3Chunk id3Chunk = ID3Chunk.readChunk(Utils.readFileDataIntoBufferLE(fc, (int)(fc.size() - fc.position())));
            if (id3Chunk != null) {
                byte version = id3Chunk.getDataBuffer().get(3);
                try {
                    switch (version) {
                        case 2: {
                            return new ID3v22Tag(id3Chunk.getDataBuffer(), fileName);
                        }
                        case 3: {
                            return new ID3v23Tag(id3Chunk.getDataBuffer(), fileName);
                        }
                        case 4: {
                            return new ID3v24Tag(id3Chunk.getDataBuffer(), fileName);
                        }
                    }
                    logger.log(Level.WARNING, fileName + " Unknown ID3v2 version " + version + ". Returning an empty ID3v2 Tag.");
                    return null;
                }
                catch (TagException e) {
                    throw new CannotReadException(fileName + " Could not read ID3v2 tag:corruption");
                }
            }
            logger.log(Level.WARNING, fileName + " No existing ID3 tag(1)");
            return null;
        }
        logger.log(Level.WARNING, fileName + " No existing ID3 tag(2)");
        return null;
    }
}

