/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.AsfHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContainerType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainerFactory;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.FieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfFieldKey;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTagBannerField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTagCoverField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTagField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTagTextField;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.GenreTypes;
import java.util.Iterator;
import java.util.List;

public final class TagConverter {
    public static void assignCommonTagValues(Tag tag, MetadataContainer description) {
        MetadataDescriptor tmp;
        assert (description.getContainerType() == ContainerType.EXTENDED_CONTENT);
        if (!Utils.isBlank(tag.getFirst(FieldKey.ALBUM))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.ALBUM.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.ALBUM));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.ALBUM.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.TRACK))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.TRACK.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.TRACK));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.TRACK.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.YEAR))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.YEAR.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.YEAR));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.YEAR.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.GENRE))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.GENRE.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.GENRE));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
            Integer genreNum = GenreTypes.getInstanceOf().getIdForName(tag.getFirst(FieldKey.GENRE));
            if (genreNum != null) {
                tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.GENRE_ID.getFieldName(), 0);
                tmp.setStringValue("(" + genreNum + ")");
                description.removeDescriptorsByName(tmp.getName());
                description.addDescriptor(tmp);
            } else {
                description.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
            }
        } else {
            description.removeDescriptorsByName(AsfFieldKey.GENRE.getFieldName());
            description.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
        }
    }

    public static AsfTag createTagOf(AsfHeader source) {
        AsfTag result = new AsfTag(true);
        for (int i = 0; i < ContainerType.values().length; ++i) {
            MetadataContainer current = source.findMetadataContainer(ContainerType.values()[i]);
            if (current == null) continue;
            List<MetadataDescriptor> descriptors = current.getDescriptors();
            for (MetadataDescriptor descriptor : descriptors) {
                AsfTagField toAdd = descriptor.getType() == 1 ? (descriptor.getName().equals(AsfFieldKey.COVER_ART.getFieldName()) ? new AsfTagCoverField(descriptor) : (descriptor.getName().equals(AsfFieldKey.BANNER_IMAGE.getFieldName()) ? new AsfTagBannerField(descriptor) : new AsfTagField(descriptor))) : new AsfTagTextField(descriptor);
                result.addField(toAdd);
            }
        }
        return result;
    }

    public static MetadataContainer[] distributeMetadata(AsfTag tag) {
        Iterator<AsfTagField> asfFields = tag.getAsfFields();
        MetadataContainer[] createContainers = MetadataContainerFactory.getInstance().createContainers(ContainerType.getOrdered());
        while (asfFields.hasNext()) {
            AsfTagField current = asfFields.next();
            boolean assigned = false;
            for (int i = 0; !assigned && i < createContainers.length; ++i) {
                if (!ContainerType.areInCorrectOrder(createContainers[i].getContainerType(), AsfFieldKey.getAsfFieldKey(current.getId()).getHighestContainer()) || !createContainers[i].isAddSupported(current.getDescriptor())) continue;
                createContainers[i].addDescriptor(current.getDescriptor());
                assigned = true;
            }
            assert (assigned);
        }
        return createContainers;
    }

    private TagConverter() {
    }
}

