/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkModifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.CountingOutputstream;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ModificationResult;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.WriteableChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WriteableChunkModifer
implements ChunkModifier {
    private final WriteableChunk writableChunk;

    public WriteableChunkModifer(WriteableChunk chunk) {
        this.writableChunk = chunk;
    }

    @Override
    public boolean isApplicable(GUID guid) {
        return guid.equals(this.writableChunk.getGuid());
    }

    @Override
    public ModificationResult modify(GUID guid, InputStream chunk, OutputStream destination) throws IOException {
        int chunkDiff = 0;
        long newSize = 0L;
        long oldSize = 0L;
        assert ((destination = new CountingOutputstream(destination)) != null);
        if (!this.writableChunk.isEmpty()) {
            newSize = this.writableChunk.writeInto(destination);
            assert (newSize == this.writableChunk.getCurrentAsfChunkSize());
            assert (((CountingOutputstream)destination).getCount() == newSize);
            if (guid == null) {
                ++chunkDiff;
            }
        }
        if (guid != null) {
            assert (this.isApplicable(guid));
            if (this.writableChunk.isEmpty()) {
                --chunkDiff;
            }
            oldSize = Utils.readUINT64(chunk);
            chunk.skip(oldSize - 24L);
        }
        return new ModificationResult(chunkDiff, newSize - oldSize, guid);
    }
}

