/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.LanguageList;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class LanguageListReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_LANGUAGE_LIST};

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long streamPosition) throws IOException {
        assert (GUID.GUID_LANGUAGE_LIST.equals(guid));
        BigInteger chunkLen = Utils.readBig64(stream);
        int readUINT16 = Utils.readUINT16(stream);
        LanguageList result = new LanguageList(streamPosition, chunkLen);
        for (int i = 0; i < readUINT16; ++i) {
            int langIdLen = stream.read() & 0xFF;
            String langId = Utils.readFixedSizeUTF16Str(stream, langIdLen);
            assert (langId.length() == langIdLen / 2 - 1 || langId.length() == langIdLen / 2);
            result.addLanguage(langId);
        }
        return result;
    }
}

