/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContentDescription;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ContentDescriptionReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_CONTENTDESCRIPTION};

    protected ContentDescriptionReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    private int[] getStringSizes(InputStream stream) throws IOException {
        int[] result = new int[5];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Utils.readUINT16(stream);
        }
        return result;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkSize = Utils.readBig64(stream);
        int[] stringSizes = this.getStringSizes(stream);
        String[] strings = new String[stringSizes.length];
        for (int i = 0; i < strings.length; ++i) {
            if (stringSizes[i] <= 0) continue;
            strings[i] = Utils.readFixedSizeUTF16Str(stream, stringSizes[i]);
        }
        ContentDescription result = new ContentDescription(chunkStart, chunkSize);
        if (stringSizes[0] > 0) {
            result.setTitle(strings[0]);
        }
        if (stringSizes[1] > 0) {
            result.setAuthor(strings[1]);
        }
        if (stringSizes[2] > 0) {
            result.setCopyright(strings[2]);
        }
        if (stringSizes[3] > 0) {
            result.setComment(strings[3]);
        }
        if (stringSizes[4] > 0) {
            result.setRating(strings[4]);
        }
        return result;
    }
}

