/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContentBranding;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ContentBrandingReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_CONTENT_BRANDING};

    protected ContentBrandingReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long streamPosition) throws IOException {
        assert (GUID.GUID_CONTENT_BRANDING.equals(guid));
        BigInteger chunkSize = Utils.readBig64(stream);
        long imageType = Utils.readUINT32(stream);
        assert (imageType >= 0L && imageType <= 3L) : imageType;
        long imageDataSize = Utils.readUINT32(stream);
        assert (imageType > 0L || imageDataSize == 0L) : imageDataSize;
        assert (imageDataSize < Integer.MAX_VALUE);
        byte[] imageData = Utils.readBinary(stream, imageDataSize);
        long copyRightUrlLen = Utils.readUINT32(stream);
        String copyRight = new String(Utils.readBinary(stream, copyRightUrlLen));
        long imageUrlLen = Utils.readUINT32(stream);
        String imageUrl = new String(Utils.readBinary(stream, imageUrlLen));
        ContentBranding result = new ContentBranding(streamPosition, chunkSize);
        result.setImage(imageType, imageData);
        result.setCopyRightURL(copyRight);
        result.setBannerImageURL(imageUrl);
        return result;
    }
}

