/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkModifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ModificationResult;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ChunkRemover
implements ChunkModifier {
    private final Set<GUID> toRemove = new HashSet<GUID>();

    public ChunkRemover(GUID ... guids) {
        for (GUID current : guids) {
            this.toRemove.add(current);
        }
    }

    @Override
    public boolean isApplicable(GUID guid) {
        return this.toRemove.contains(guid);
    }

    @Override
    public ModificationResult modify(GUID guid, InputStream source, OutputStream destination) throws IOException {
        ModificationResult result;
        if (guid == null) {
            result = new ModificationResult(0, 0L, new GUID[0]);
        } else {
            assert (this.isApplicable(guid));
            long chunkLen = Utils.readUINT64(source);
            source.skip(chunkLen - 24L);
            result = new ModificationResult(-1, -1L * chunkLen, guid);
        }
        return result;
    }
}

