/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.math.BigInteger;

public abstract class StreamChunk
extends Chunk {
    private boolean contentEncrypted;
    private int streamNumber;
    private long streamSpecificDataSize;
    private long timeOffset;
    private final GUID type;
    private long typeSpecificDataSize;

    public StreamChunk(GUID streamType, BigInteger chunkLen) {
        super(GUID.GUID_STREAM, chunkLen);
        assert (GUID.GUID_AUDIOSTREAM.equals(streamType) || GUID.GUID_VIDEOSTREAM.equals(streamType));
        this.type = streamType;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public long getStreamSpecificDataSize() {
        return this.streamSpecificDataSize;
    }

    public GUID getStreamType() {
        return this.type;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTypeSpecificDataSize() {
        return this.typeSpecificDataSize;
    }

    public boolean isContentEncrypted() {
        return this.contentEncrypted;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.append(prefix).append("  |-> Stream number: ").append(this.getStreamNumber()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |-> Type specific data size  : ").append(this.getTypeSpecificDataSize()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |-> Stream specific data size: ").append(this.getStreamSpecificDataSize()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |-> Time Offset              : ").append(this.getTimeOffset()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  |-> Content Encryption       : ").append(this.isContentEncrypted()).append(Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setContentEncrypted(boolean cntEnc) {
        this.contentEncrypted = cntEnc;
    }

    public void setStreamNumber(int streamNum) {
        this.streamNumber = streamNum;
    }

    public void setStreamSpecificDataSize(long strSpecDataSize) {
        this.streamSpecificDataSize = strSpecDataSize;
    }

    public void setTimeOffset(long timeOffs) {
        this.timeOffset = timeOffs;
    }

    public void setTypeSpecificDataSize(long typeSpecDataSize) {
        this.typeSpecificDataSize = typeSpecDataSize;
    }
}

