/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class StreamBitratePropertiesChunk
extends Chunk {
    private final List<Long> bitRates = new ArrayList<Long>();
    private final List<Integer> streamNumbers = new ArrayList<Integer>();

    public StreamBitratePropertiesChunk(BigInteger chunkLen) {
        super(GUID.GUID_STREAM_BITRATE_PROPERTIES, chunkLen);
    }

    public void addBitrateRecord(int streamNum, long averageBitrate) {
        this.streamNumbers.add(streamNum);
        this.bitRates.add(averageBitrate);
    }

    public long getAvgBitrate(int streamNumber) {
        Integer seach = streamNumber;
        int index = this.streamNumbers.indexOf(seach);
        long result = index == -1 ? -1L : this.bitRates.get(index);
        return result;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        for (int i = 0; i < this.bitRates.size(); ++i) {
            result.append(prefix).append("  |-> Stream no. \"").append(this.streamNumbers.get(i)).append("\" has an average bitrate of \"").append(this.bitRates.get(i)).append('\"').append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }
}

