/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContainerType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContentBranding;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContentDescription;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import java.math.BigInteger;

public final class MetadataContainerFactory {
    private static final MetadataContainerFactory INSTANCE = new MetadataContainerFactory();

    public static MetadataContainerFactory getInstance() {
        return INSTANCE;
    }

    private MetadataContainerFactory() {
    }

    public MetadataContainer createContainer(ContainerType type) {
        return this.createContainer(type, 0L, BigInteger.ZERO);
    }

    public MetadataContainer createContainer(ContainerType type, long pos, BigInteger chunkSize) {
        MetadataContainer result = type == ContainerType.CONTENT_DESCRIPTION ? new ContentDescription(pos, chunkSize) : (type == ContainerType.CONTENT_BRANDING ? new ContentBranding(pos, chunkSize) : new MetadataContainer(type, pos, chunkSize));
        return result;
    }

    public MetadataContainer[] createContainers(ContainerType[] types) {
        assert (types != null);
        MetadataContainer[] result = new MetadataContainer[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createContainer(types[i]);
        }
        return result;
    }
}

