/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUIDFormatException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class GUID {
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT = new GUID(new int[]{64, 164, 241, 73, 206, 78, 208, 17, 163, 172, 0, 160, 201, 3, 72, 246}, "Audio error concealment absent.");
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED = new GUID(new int[]{64, 164, 241, 73, 206, 78, 208, 17, 163, 172, 0, 160, 201, 3, 72, 246}, "Interleaved audio error concealment.");
    public static final GUID GUID_AUDIOSTREAM = new GUID(new int[]{64, 158, 105, 248, 77, 91, 207, 17, 168, 253, 0, 128, 95, 92, 68, 43}, " Audio stream");
    public static final GUID GUID_CONTENT_BRANDING = new GUID(new int[]{250, 179, 17, 34, 35, 189, 210, 17, 180, 183, 0, 160, 201, 85, 252, 110}, "Content Branding");
    public static final GUID GUID_CONTENT_ENCRYPTION = new GUID(new int[]{251, 179, 17, 34, 35, 189, 210, 17, 180, 183, 0, 160, 201, 85, 252, 110}, "Content Encryption Object");
    public static final GUID GUID_CONTENTDESCRIPTION = new GUID(new int[]{51, 38, 178, 117, 142, 102, 207, 17, 166, 217, 0, 170, 0, 98, 206, 108}, "Content Description");
    public static final GUID GUID_ENCODING = new GUID(new int[]{64, 82, 209, 134, 29, 49, 208, 17, 163, 164, 0, 160, 201, 3, 72, 246}, "Encoding description");
    public static final GUID GUID_EXTENDED_CONTENT_DESCRIPTION = new GUID(new int[]{64, 164, 208, 210, 7, 227, 210, 17, 151, 240, 0, 160, 201, 94, 168, 80}, "Extended Content Description");
    public static final GUID GUID_FILE = new GUID(new int[]{161, 220, 171, 140, 71, 169, 207, 17, 142, 228, 0, 192, 12, 32, 83, 101}, "File header");
    public static final GUID GUID_HEADER = new GUID(new int[]{48, 38, 178, 117, 142, 102, 207, 17, 166, 217, 0, 170, 0, 98, 206, 108}, "Asf header");
    public static final GUID GUID_HEADER_EXTENSION = new GUID(new int[]{181, 3, 191, 95, 46, 169, 207, 17, 142, 227, 0, 192, 12, 32, 83, 101}, "Header Extension");
    public static final GUID GUID_LANGUAGE_LIST = new GUID(new int[]{169, 70, 67, 124, 224, 239, 252, 75, 178, 41, 57, 62, 222, 65, 92, 133}, "Language List");
    public static final int GUID_LENGTH = 16;
    public static final GUID GUID_METADATA = new GUID(new int[]{234, 203, 248, 197, 175, 91, 119, 72, 132, 103, 170, 140, 68, 250, 76, 202}, "Metadata");
    public static final GUID GUID_METADATA_LIBRARY = new GUID(new int[]{148, 28, 35, 68, 152, 148, 209, 73, 161, 65, 29, 19, 78, 69, 112, 84}, "Metadata Library");
    private static final Pattern GUID_PATTERN = Pattern.compile("[a-f0-9]{8}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{12}", 2);
    public static final GUID GUID_STREAM = new GUID(new int[]{145, 7, 220, 183, 183, 169, 207, 17, 142, 230, 0, 192, 12, 32, 83, 101}, "Stream");
    public static final GUID GUID_STREAM_BITRATE_PROPERTIES = new GUID(new int[]{206, 117, 248, 123, 141, 70, 209, 17, 141, 130, 0, 96, 151, 201, 162, 178}, "Stream bitrate properties");
    private static final Map<GUID, GUID> GUID_TO_CONFIGURED;
    public static final GUID GUID_UNSPECIFIED;
    public static final GUID GUID_VIDEOSTREAM;
    public static final GUID[] KNOWN_GUIDS;
    public static final GUID SCRIPT_COMMAND_OBJECT;
    private String description = "";
    private int[] guidData = null;
    private int hash;

    public static boolean assertGUID(int[] value) {
        return value != null && value.length == 16;
    }

    public static GUID getConfigured(GUID orig) {
        return GUID_TO_CONFIGURED.get(orig);
    }

    public static String getGuidDescription(GUID guid) {
        String result = null;
        if (guid == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        if (GUID.getConfigured(guid) != null) {
            result = GUID.getConfigured(guid).getDescription();
        }
        return result;
    }

    public static GUID parseGUID(String guid) throws GUIDFormatException {
        if (guid == null) {
            throw new GUIDFormatException("null");
        }
        if (!GUID_PATTERN.matcher(guid).matches()) {
            throw new GUIDFormatException("Invalid guidData format.");
        }
        int[] bytes = new int[16];
        int[] arrayIndices = new int[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 10, 11, 12, 13, 14, 15};
        int arrayPointer = 0;
        for (int i = 0; i < guid.length(); ++i) {
            if (guid.charAt(i) == '-') continue;
            bytes[arrayIndices[arrayPointer++]] = Integer.parseInt(guid.substring(i, i + 2), 16);
            ++i;
        }
        return new GUID(bytes);
    }

    public GUID(byte[] value) {
        assert (value != null);
        int[] tmp = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            tmp[i] = 0xFF & value[i];
        }
        this.setGUID(tmp);
    }

    public GUID(int[] value) {
        this.setGUID(value);
    }

    public GUID(int[] value, String desc) {
        this(value);
        if (desc == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.description = desc;
    }

    public GUID(String guidString, String desc) {
        this(GUID.parseGUID(guidString).getGUID());
        if (desc == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.description = desc;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof GUID) {
            GUID other = (GUID)obj;
            result = Arrays.equals(this.getGUID(), other.getGUID());
        }
        return result;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.guidData.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(this.guidData[i] & 0xFF);
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getGUID() {
        int[] copy = new int[this.guidData.length];
        System.arraycopy(this.guidData, 0, copy, 0, this.guidData.length);
        return copy;
    }

    private String[] getHex(byte[] bytes) {
        String[] result = new String[bytes.length];
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            tmp.delete(0, tmp.length());
            tmp.append(Integer.toHexString(0xFF & bytes[i]));
            if (tmp.length() == 1) {
                tmp.insert(0, "0");
            }
            result[i] = tmp.toString();
        }
        return result;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int tmp = 0;
            for (int curr : this.getGUID()) {
                tmp = tmp * 31 + curr;
            }
            this.hash = tmp;
        }
        return this.hash;
    }

    public boolean isValid() {
        return GUID.assertGUID(this.getGUID());
    }

    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        String descr = this.getDescription();
        if (Utils.isBlank(descr)) {
            descr = GUID.getGuidDescription(this);
        }
        if (!Utils.isBlank(descr)) {
            result.append("Description: ").append(descr).append(Utils.LINE_SEPARATOR).append("   ");
        }
        result.append(this.toString());
        return result.toString();
    }

    private void setGUID(int[] value) {
        if (!GUID.assertGUID(value)) {
            throw new IllegalArgumentException("The given guidData doesn't match the GUID specification.");
        }
        this.guidData = new int[16];
        System.arraycopy(value, 0, this.guidData, 0, 16);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String[] bytes = this.getHex(this.getBytes());
        result.append(bytes[3]);
        result.append(bytes[2]);
        result.append(bytes[1]);
        result.append(bytes[0]);
        result.append('-');
        result.append(bytes[5]);
        result.append(bytes[4]);
        result.append('-');
        result.append(bytes[7]);
        result.append(bytes[6]);
        result.append('-');
        result.append(bytes[8]);
        result.append(bytes[9]);
        result.append('-');
        result.append(bytes[10]);
        result.append(bytes[11]);
        result.append(bytes[12]);
        result.append(bytes[13]);
        result.append(bytes[14]);
        result.append(bytes[15]);
        return result.toString();
    }

    static {
        GUID_UNSPECIFIED = new GUID(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "Unspecified");
        GUID_VIDEOSTREAM = new GUID(new int[]{192, 239, 25, 188, 77, 91, 207, 17, 168, 253, 0, 128, 95, 92, 68, 43}, "Video stream");
        SCRIPT_COMMAND_OBJECT = new GUID(new int[]{48, 26, 251, 30, 98, 11, 208, 17, 163, 155, 0, 160, 201, 3, 72, 246}, "Script Command Object");
        KNOWN_GUIDS = new GUID[]{GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT, GUID_CONTENTDESCRIPTION, GUID_AUDIOSTREAM, GUID_ENCODING, GUID_FILE, GUID_HEADER, GUID_STREAM, GUID_EXTENDED_CONTENT_DESCRIPTION, GUID_VIDEOSTREAM, GUID_HEADER_EXTENSION, GUID_STREAM_BITRATE_PROPERTIES, SCRIPT_COMMAND_OBJECT, GUID_CONTENT_ENCRYPTION, GUID_CONTENT_BRANDING, GUID_UNSPECIFIED, GUID_METADATA_LIBRARY, GUID_METADATA, GUID_LANGUAGE_LIST};
        GUID_TO_CONFIGURED = new HashMap<GUID, GUID>(KNOWN_GUIDS.length);
        for (GUID curr : KNOWN_GUIDS) {
            assert (!GUID_TO_CONFIGURED.containsKey(curr)) : "Double definition: \"" + GUID_TO_CONFIGURED.get(curr).getDescription() + "\" <-> \"" + curr.getDescription() + "\"";
            GUID_TO_CONFIGURED.put(curr, curr);
        }
    }
}

