/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContainerType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public final class ContentBranding
extends MetadataContainer {
    public static final Set<String> ALLOWED = new HashSet<String>();
    public static final String KEY_BANNER_IMAGE = "BANNER_IMAGE";
    public static final String KEY_BANNER_TYPE = "BANNER_IMAGE_TYPE";
    public static final String KEY_BANNER_URL = "BANNER_IMAGE_URL";
    public static final String KEY_COPYRIGHT_URL = "COPYRIGHT_URL";

    public ContentBranding() {
        this(0L, BigInteger.ZERO);
    }

    public ContentBranding(long pos, BigInteger size) {
        super(ContainerType.CONTENT_BRANDING, pos, size);
    }

    public String getBannerImageURL() {
        return this.getValueFor(KEY_BANNER_URL);
    }

    public String getCopyRightURL() {
        return this.getValueFor(KEY_COPYRIGHT_URL);
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long result = 40L;
        result += (long)this.assertDescriptor(KEY_BANNER_IMAGE, 1).getRawDataSize();
        result += (long)this.getBannerImageURL().length();
        return result += (long)this.getCopyRightURL().length();
    }

    public byte[] getImageData() {
        return this.assertDescriptor(KEY_BANNER_IMAGE, 1).getRawData();
    }

    public long getImageType() {
        if (!this.hasDescriptor(KEY_BANNER_TYPE)) {
            MetadataDescriptor descriptor = new MetadataDescriptor(ContainerType.CONTENT_BRANDING, KEY_BANNER_TYPE, 3);
            descriptor.setDWordValue(0L);
            this.addDescriptor(descriptor);
        }
        return this.assertDescriptor(KEY_BANNER_TYPE).getNumber();
    }

    @Override
    public boolean isAddSupported(MetadataDescriptor descriptor) {
        return ALLOWED.contains(descriptor.getName()) && super.isAddSupported(descriptor);
    }

    public void setBannerImageURL(String imageURL) {
        if (Utils.isBlank(imageURL)) {
            this.removeDescriptorsByName(KEY_BANNER_URL);
        } else {
            this.assertDescriptor(KEY_BANNER_URL).setStringValue(imageURL);
        }
    }

    public void setCopyRightURL(String copyRight) {
        if (Utils.isBlank(copyRight)) {
            this.removeDescriptorsByName(KEY_COPYRIGHT_URL);
        } else {
            this.assertDescriptor(KEY_COPYRIGHT_URL).setStringValue(copyRight);
        }
    }

    public void setImage(long imageType, byte[] imageData) {
        assert (imageType >= 0L && imageType <= 3L);
        assert (imageType > 0L || imageData.length == 0);
        this.assertDescriptor(KEY_BANNER_TYPE, 3).setDWordValue(imageType);
        this.assertDescriptor(KEY_BANNER_IMAGE, 1).setBinaryValue(imageData);
    }

    @Override
    public long writeInto(OutputStream out) throws IOException {
        long chunkSize = this.getCurrentAsfChunkSize();
        out.write(this.getGuid().getBytes());
        Utils.writeUINT64(chunkSize, out);
        Utils.writeUINT32(this.getImageType(), out);
        assert (this.getImageType() >= 0L && this.getImageType() <= 3L);
        byte[] imageData = this.getImageData();
        assert (this.getImageType() > 0L || imageData.length == 0);
        Utils.writeUINT32(imageData.length, out);
        out.write(imageData);
        Utils.writeUINT32(this.getBannerImageURL().length(), out);
        out.write(this.getBannerImageURL().getBytes(StandardCharsets.US_ASCII));
        Utils.writeUINT32(this.getCopyRightURL().length(), out);
        out.write(this.getCopyRightURL().getBytes(StandardCharsets.US_ASCII));
        return chunkSize;
    }

    static {
        ALLOWED.add(KEY_BANNER_IMAGE);
        ALLOWED.add(KEY_BANNER_TYPE);
        ALLOWED.add(KEY_BANNER_URL);
        ALLOWED.add(KEY_COPYRIGHT_URL);
    }
}

