/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.math.BigInteger;

public class Chunk {
    protected final BigInteger chunkLength;
    protected final GUID guid;
    protected long position;

    public Chunk(GUID headerGuid, BigInteger chunkLen) {
        if (headerGuid == null) {
            throw new IllegalArgumentException("GUID must not be null.");
        }
        if (chunkLen == null || chunkLen.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = headerGuid;
        this.chunkLength = chunkLen;
    }

    public Chunk(GUID headerGuid, long pos, BigInteger chunkLen) {
        if (headerGuid == null) {
            throw new IllegalArgumentException("GUID must not be null");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("Position of header can't be negative.");
        }
        if (chunkLen == null || chunkLen.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = headerGuid;
        this.position = pos;
        this.chunkLength = chunkLen;
    }

    @Deprecated
    public long getChunckEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public long getChunkEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public BigInteger getChunkLength() {
        return this.chunkLength;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public long getPosition() {
        return this.position;
    }

    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder();
        result.append(prefix).append("-> GUID: ").append(GUID.getGuidDescription(this.guid)).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  | : Starts at position: ").append(this.getPosition()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("  | : Last byte at: ").append(this.getChunkEnd() - 1L).append(Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public String toString() {
        return this.prettyPrint("");
    }
}

