/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.AsfExtendedHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ChunkContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContainerType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ContentDescription;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.EncodingChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.EncryptionChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.FileHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.GUID;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;

public final class AsfHeader
extends ChunkContainer {
    public static final Charset ASF_CHARSET = Charset.forName("UTF-16LE");
    public static final byte[] ZERO_TERM = new byte[]{0, 0};
    private final long chunkCount;

    public AsfHeader(long pos, BigInteger chunkLen, long chunkCnt) {
        super(GUID.GUID_HEADER, pos, chunkLen);
        this.chunkCount = chunkCnt;
    }

    public ContentDescription findContentDescription() {
        ContentDescription result = this.getContentDescription();
        if (result == null && this.getExtendedHeader() != null) {
            result = this.getExtendedHeader().getContentDescription();
        }
        return result;
    }

    public MetadataContainer findExtendedContentDescription() {
        MetadataContainer result = this.getExtendedContentDescription();
        if (result == null && this.getExtendedHeader() != null) {
            result = this.getExtendedHeader().getExtendedContentDescription();
        }
        return result;
    }

    public MetadataContainer findMetadataContainer(ContainerType type) {
        MetadataContainer result = (MetadataContainer)this.getFirst(type.getContainerGUID(), MetadataContainer.class);
        if (result == null) {
            result = (MetadataContainer)this.getExtendedHeader().getFirst(type.getContainerGUID(), MetadataContainer.class);
        }
        return result;
    }

    public AudioStreamChunk getAudioStreamChunk() {
        AudioStreamChunk result = null;
        List<Chunk> streamChunks = this.assertChunkList(GUID.GUID_STREAM);
        for (int i = 0; i < streamChunks.size() && result == null; ++i) {
            if (!(streamChunks.get(i) instanceof AudioStreamChunk)) continue;
            result = (AudioStreamChunk)streamChunks.get(i);
        }
        return result;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public ContentDescription getContentDescription() {
        return (ContentDescription)this.getFirst(GUID.GUID_CONTENTDESCRIPTION, ContentDescription.class);
    }

    public EncodingChunk getEncodingChunk() {
        return (EncodingChunk)this.getFirst(GUID.GUID_ENCODING, EncodingChunk.class);
    }

    public EncryptionChunk getEncryptionChunk() {
        return (EncryptionChunk)this.getFirst(GUID.GUID_CONTENT_ENCRYPTION, EncryptionChunk.class);
    }

    public MetadataContainer getExtendedContentDescription() {
        return (MetadataContainer)this.getFirst(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, MetadataContainer.class);
    }

    public AsfExtendedHeader getExtendedHeader() {
        return (AsfExtendedHeader)this.getFirst(GUID.GUID_HEADER_EXTENSION, AsfExtendedHeader.class);
    }

    public FileHeader getFileHeader() {
        return (FileHeader)this.getFirst(GUID.GUID_FILE, FileHeader.class);
    }

    public StreamBitratePropertiesChunk getStreamBitratePropertiesChunk() {
        return (StreamBitratePropertiesChunk)this.getFirst(GUID.GUID_STREAM_BITRATE_PROPERTIES, StreamBitratePropertiesChunk.class);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix, prefix + "  | : Contains: \"" + this.getChunkCount() + "\" chunks" + Utils.LINE_SEPARATOR));
        return result.toString();
    }

    static {
        HashSet<GUID> MULTI_CHUNKS = new HashSet<GUID>();
        MULTI_CHUNKS.add(GUID.GUID_STREAM);
    }
}

