/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFile;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.AsfHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.ChunkContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.AsfExtHeaderModifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.AsfStreamer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkModifier;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.RandomAccessFileOutputStream;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.WriteableChunkModifer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.TagConverter;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileWriter;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class AsfFileWriter
extends AudioFileWriter {
    @Override
    protected void deleteTag(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotWriteException, IOException {
        this.writeTag(null, new AsfTag(true), raf, tempRaf);
    }

    private boolean[] searchExistence(ChunkContainer container, MetadataContainer[] metaContainers) {
        assert (container != null);
        assert (metaContainers != null);
        boolean[] result = new boolean[metaContainers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = container.hasChunkByGUID(metaContainers[i].getContainerType().getContainerGUID());
        }
        return result;
    }

    @Override
    protected void writeTag(AudioFile audioFile, Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        AsfHeader sourceHeader = AsfHeaderReader.readTagHeader(raf);
        raf.seek(0L);
        AsfTag copy = new AsfTag(tag, true);
        MetadataContainer[] distribution = TagConverter.distributeMetadata(copy);
        boolean[] existHeader = this.searchExistence(sourceHeader, distribution);
        boolean[] existExtHeader = this.searchExistence(sourceHeader.getExtendedHeader(), distribution);
        ArrayList<ChunkModifier> headerModifier = new ArrayList<ChunkModifier>();
        ArrayList<ChunkModifier> extHeaderModifier = new ArrayList<ChunkModifier>();
        for (int i = 0; i < distribution.length; ++i) {
            WriteableChunkModifer modifier = new WriteableChunkModifer(distribution[i]);
            if (existHeader[i]) {
                headerModifier.add(modifier);
                continue;
            }
            if (existExtHeader[i]) {
                extHeaderModifier.add(modifier);
                continue;
            }
            if (i == 0 || i == 2 || i == 1) {
                headerModifier.add(modifier);
                continue;
            }
            extHeaderModifier.add(modifier);
        }
        if (!extHeaderModifier.isEmpty()) {
            headerModifier.add(new AsfExtHeaderModifier(extHeaderModifier));
        }
        new AsfStreamer().createModifiedCopy(new RandomAccessFileInputstream(raf), new RandomAccessFileOutputStream(rafTemp), headerModifier);
    }
}

