/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFile;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.AsfHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataContainer;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.AsfExtHeaderReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ContentBrandingReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.FileHeaderReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.FullRequestInputStream;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.LanguageListReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.MetadataReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.io.StreamChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.TagConverter;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf.util.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.AudioFileReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagException;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTag;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AsfFileReader
extends AudioFileReader {
    private static final Logger LOGGER = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.asf");
    private static final AsfHeaderReader HEADER_READER;

    private boolean determineVariableBitrate(AsfHeader header) {
        List<MetadataDescriptor> descriptors;
        assert (header != null);
        boolean result = false;
        MetadataContainer extDesc = header.findExtendedContentDescription();
        if (extDesc != null && (descriptors = extDesc.getDescriptorsByName("IsVBR")) != null && !descriptors.isEmpty()) {
            result = Boolean.TRUE.toString().equals(descriptors.get(0).getString());
        }
        return result;
    }

    private GenericAudioHeader getAudioHeader(AsfHeader header) throws CannotReadException {
        GenericAudioHeader info = new GenericAudioHeader();
        if (header.getFileHeader() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. File header object not available.");
        }
        if (header.getAudioStreamChunk() == null) {
            throw new CannotReadException("Invalid ASF/WMA file. No audio stream contained.");
        }
        info.setBitRate(header.getAudioStreamChunk().getKbps());
        info.setChannelNumber((int)header.getAudioStreamChunk().getChannelCount());
        info.setEncodingType("ASF (audio): " + header.getAudioStreamChunk().getCodecDescription());
        info.setLossless(header.getAudioStreamChunk().getCompressionFormat() == 355L);
        info.setPreciseLength(header.getFileHeader().getPreciseDuration());
        info.setSamplingRate((int)header.getAudioStreamChunk().getSamplingRate());
        info.setVariableBitRate(this.determineVariableBitrate(header));
        info.setBitsPerSample(header.getAudioStreamChunk().getBitsPerSample());
        return info;
    }

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        GenericAudioHeader info;
        raf.seek(0L);
        try {
            AsfHeader header = AsfHeaderReader.readInfoHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            info = this.getAudioHeader(header);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage(), e);
        }
        return info;
    }

    private AsfTag getTag(AsfHeader header) {
        return TagConverter.createTagOf(header);
    }

    @Override
    protected AsfTag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        AsfTag tag;
        raf.seek(0L);
        try {
            AsfHeader header = AsfHeaderReader.readTagHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            tag = TagConverter.createTagOf(header);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage());
        }
        return tag;
    }

    @Override
    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        if (!f.canRead()) {
            if (!f.exists()) {
                logger.severe("Unable to find:" + f.getPath());
                throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(f.getPath()));
            }
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(f.getAbsolutePath()));
        }
        InputStream stream = null;
        try {
            stream = new FullRequestInputStream(new BufferedInputStream(new FileInputStream(f)));
            AsfHeader header = (AsfHeader)HEADER_READER.read(Utils.readGUID(stream), stream, 0L);
            if (header == null) {
                throw new CannotReadException(ErrorMessage.ASF_HEADER_MISSING.getMsg(f.getAbsolutePath()));
            }
            if (header.getFileHeader() == null) {
                throw new CannotReadException(ErrorMessage.ASF_FILE_HEADER_MISSING.getMsg(f.getAbsolutePath()));
            }
            if (header.getFileHeader().getFileSize().longValue() != f.length()) {
                logger.warning(ErrorMessage.ASF_FILE_HEADER_SIZE_DOES_NOT_MATCH_FILE_SIZE.getMsg(f.getAbsolutePath(), header.getFileHeader().getFileSize().longValue(), f.length()));
            }
            AudioFile audioFile = new AudioFile(f, (AudioHeader)this.getAudioHeader(header), (Tag)this.getTag(header));
            return audioFile;
        }
        catch (CannotReadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotReadException("\"" + f + "\" :" + e, e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception ex) {
                LOGGER.severe("\"" + f + "\" :" + ex);
            }
        }
    }

    static {
        ArrayList<Class<? extends ChunkReader>> readers = new ArrayList<Class<? extends ChunkReader>>();
        readers.add(ContentDescriptionReader.class);
        readers.add(ContentBrandingReader.class);
        readers.add(MetadataReader.class);
        readers.add(LanguageListReader.class);
        AsfExtHeaderReader extReader = new AsfExtHeaderReader(readers, true);
        readers.add(FileHeaderReader.class);
        readers.add(StreamChunkReader.class);
        HEADER_READER = new AsfHeaderReader(readers, true);
        HEADER_READER.setExtendedHeaderReader(extReader);
    }
}

