/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffUtil;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AiffCompressionType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CommonChunk
extends Chunk {
    private AiffAudioHeader aiffHeader;

    public CommonChunk(ChunkHeader hdr, ByteBuffer chunkData, AiffAudioHeader aiffAudioHeader) {
        super(chunkData, hdr);
        this.aiffHeader = aiffAudioHeader;
    }

    @Override
    public boolean readChunk() throws IOException {
        int numChannels = Utils.u(this.chunkData.getShort());
        long numSamples = this.chunkData.getInt();
        int bitsPerSample = Utils.u(this.chunkData.getShort());
        double sampleRate = AiffUtil.read80BitDouble(this.chunkData);
        if (this.aiffHeader.getFileType() == AiffType.AIFC) {
            if (this.chunkData.remaining() == 0) {
                return false;
            }
            String compressionType = Utils.readFourBytesAsChars(this.chunkData);
            if (compressionType.equals(AiffCompressionType.SOWT.getCode())) {
                this.aiffHeader.setEndian(AiffAudioHeader.Endian.LITTLE_ENDIAN);
            }
            String compressionName = Utils.readPascalString(this.chunkData);
            if (compressionType != null) {
                AiffCompressionType act = AiffCompressionType.getByCode(compressionType);
                if (act != null) {
                    compressionName = act.getCompression();
                    this.aiffHeader.setLossless(act.isLossless());
                    if (act == AiffCompressionType.NONE) {
                        this.aiffHeader.setVariableBitRate(false);
                    }
                } else {
                    this.aiffHeader.setLossless(false);
                }
                if (compressionName.isEmpty()) {
                    this.aiffHeader.setEncodingType(compressionType);
                } else {
                    this.aiffHeader.setEncodingType(compressionName);
                }
            }
        } else {
            this.aiffHeader.setLossless(true);
            this.aiffHeader.setEncodingType(AiffCompressionType.NONE.getCompression());
            this.aiffHeader.setVariableBitRate(false);
        }
        this.aiffHeader.setBitsPerSample(bitsPerSample);
        this.aiffHeader.setSamplingRate((int)sampleRate);
        this.aiffHeader.setChannelNumber(numChannels);
        this.aiffHeader.setPreciseLength((double)numSamples / sampleRate);
        this.aiffHeader.setNoOfSamples(numSamples);
        return true;
    }
}

