/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffUtil;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class CommentsChunk
extends Chunk {
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int MARKERID_LENGTH = 2;
    private static final int COUNT_LENGTH = 2;
    private AiffAudioHeader aiffHeader;

    public CommentsChunk(ChunkHeader chunkHeader, ByteBuffer chunkData, AiffAudioHeader aiffAudioHeader) {
        super(chunkData, chunkHeader);
        this.aiffHeader = aiffAudioHeader;
    }

    @Override
    public boolean readChunk() throws IOException {
        int numComments = Utils.u(this.chunkData.getShort());
        for (int i = 0; i < numComments; ++i) {
            long timestamp = Utils.u(this.chunkData.getInt());
            Date jTimestamp = AiffUtil.timestampToDate(timestamp);
            int marker = Utils.u(this.chunkData.getShort());
            int count = Utils.u(this.chunkData.getShort());
            String text = Utils.getString(this.chunkData, 0, count, StandardCharsets.ISO_8859_1) + " " + AiffUtil.formatDate(jTimestamp);
            if (count % 2 != 0) {
                this.chunkData.get();
            }
            this.aiffHeader.addComment(text);
        }
        return true;
    }
}

