/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ApplicationChunk
extends Chunk {
    private static final String SIGNATURE_PDOS = "pdos";
    private static final String SIGNATURE_STOC = "stoc";
    private AiffAudioHeader aiffHeader;

    public ApplicationChunk(ChunkHeader chunkHeader, ByteBuffer chunkData, AiffAudioHeader aiffAudioHeader) {
        super(chunkData, chunkHeader);
        this.aiffHeader = aiffAudioHeader;
    }

    @Override
    public boolean readChunk() throws IOException {
        String applicationSignature = Utils.readFourBytesAsChars(this.chunkData);
        String applicationName = null;
        if (SIGNATURE_STOC.equals(applicationSignature) || SIGNATURE_PDOS.equals(applicationSignature)) {
            applicationName = Utils.readPascalString(this.chunkData);
        }
        this.aiffHeader.addApplicationIdentifier(applicationSignature + ": " + applicationName);
        return true;
    }
}

