/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffFileHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AiffChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.ID3Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkSummary;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.aiff.AiffTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class AiffTagReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff");
    private String loggingName;

    public AiffTagReader(String loggingName) {
        this.loggingName = loggingName;
    }

    public AiffTag read(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            AiffAudioHeader aiffAudioHeader = new AiffAudioHeader();
            AiffTag aiffTag = new AiffTag();
            AiffFileHeader fileHeader = new AiffFileHeader();
            fileHeader.readHeader(fc, aiffAudioHeader, file.toString());
            while (fc.position() < fc.size()) {
                if (this.readChunk(fc, aiffTag)) continue;
                logger.severe(file + ":UnableToReadProcessChunk");
                break;
            }
            if (aiffTag.getID3Tag() == null) {
                aiffTag.setID3Tag(AiffTag.createDefaultID3Tag());
            }
            AiffTag aiffTag2 = aiffTag;
            return aiffTag2;
        }
    }

    private boolean readChunk(FileChannel fc, AiffTag aiffTag) throws IOException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        logger.config(this.loggingName + ":Reading Chunk:" + chunkHeader.getID() + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
        long startLocationOfId3TagInFile = fc.position();
        AiffChunkType chunkType = AiffChunkType.get(chunkHeader.getID());
        if (chunkType != null && chunkType == AiffChunkType.TAG && chunkHeader.getSize() > 0L) {
            ByteBuffer chunkData = this.readChunkDataIntoBuffer(fc, chunkHeader);
            aiffTag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
            if (aiffTag.getID3Tag() == null) {
                ID3Chunk chunk = new ID3Chunk(chunkHeader, chunkData, aiffTag, this.loggingName);
                ((Chunk)chunk).readChunk();
                aiffTag.setExistingId3Tag(true);
                aiffTag.getID3Tag().setStartLocationInFile(startLocationOfId3TagInFile);
                aiffTag.getID3Tag().setEndLocationInFile(fc.position());
            } else {
                logger.warning(this.loggingName + ":Ignoring ID3Tag because already have one:" + chunkHeader.getID() + ":" + chunkHeader.getStartLocationInFile() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile() - 1L) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
            }
        } else {
            if (chunkType != null && chunkType == AiffChunkType.CORRUPT_TAG_LATE) {
                logger.warning(this.loggingName + ":Found Corrupt ID3 Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile() - 1L) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                if (aiffTag.getID3Tag() == null) {
                    aiffTag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 9L);
                return true;
            }
            if (chunkType != null && chunkType == AiffChunkType.CORRUPT_TAG_EARLY) {
                logger.warning(this.loggingName + ":Found Corrupt ID3 Chunk, starting at Odd Location:" + chunkHeader.getID() + ":" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                if (aiffTag.getID3Tag() == null) {
                    aiffTag.setIncorrectlyAlignedTag(true);
                }
                fc.position(fc.position() - 7L);
                return true;
            }
            logger.config(this.loggingName + ":Skipping Chunk:" + chunkHeader.getID() + ":" + chunkHeader.getSize());
            aiffTag.addChunkSummary(new ChunkSummary(chunkHeader.getID(), chunkHeader.getStartLocationInFile(), chunkHeader.getSize()));
            fc.position(fc.position() + chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }
}

