/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffFileHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AiffChunkType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AnnotationChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.ApplicationChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.AuthorChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.CommentsChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.CommonChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.CopyrightChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.FormatVersionChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.chunk.NameChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.Chunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.ChunkHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class AiffInfoReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff");
    private String loggingName;

    public AiffInfoReader(String loggingName) {
        this.loggingName = loggingName;
    }

    protected GenericAudioHeader read(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            logger.config(this.loggingName + ":Reading AIFF file size:" + Hex.asDecAndHex(fc.size()));
            AiffAudioHeader aiffAudioHeader = new AiffAudioHeader();
            AiffFileHeader fileHeader = new AiffFileHeader();
            long noOfBytes = fileHeader.readHeader(fc, aiffAudioHeader, file.toString());
            while (fc.position() < fc.size()) {
                if (this.readChunk(fc, aiffAudioHeader)) continue;
                logger.severe(file + ":UnableToReadProcessChunk");
                break;
            }
            this.calculateBitRate(aiffAudioHeader);
            AiffAudioHeader aiffAudioHeader2 = aiffAudioHeader;
            return aiffAudioHeader2;
        }
    }

    private void calculateBitRate(GenericAudioHeader info) throws CannotReadException {
        if (info.getAudioDataLength() != null) {
            info.setBitRate((int)Math.round((double)(info.getAudioDataLength() * (long)Utils.BITS_IN_BYTE_MULTIPLIER) / (info.getPreciseTrackLength() * (double)Utils.KILOBYTE_MULTIPLIER)));
        }
    }

    private boolean readChunk(FileChannel fc, AiffAudioHeader aiffAudioHeader) throws IOException, CannotReadException {
        logger.config(this.loggingName + ":Reading Info Chunk");
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        logger.config(this.loggingName + ":Reading Next Chunk:" + chunkHeader.getID() + ":starting at:" + chunkHeader.getStartLocationInFile() + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
        Chunk chunk = this.createChunk(fc, chunkHeader, aiffAudioHeader);
        if (chunk != null) {
            if (!chunk.readChunk()) {
                logger.severe(this.loggingName + ":ChunkReadFail:" + chunkHeader.getID());
                return false;
            }
        } else {
            if (chunkHeader.getSize() < 0L) {
                String msg = this.loggingName + ":Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
            fc.position(fc.position() + chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }

    private Chunk createChunk(FileChannel fc, ChunkHeader chunkHeader, AiffAudioHeader aiffAudioHeader) throws IOException {
        Chunk chunk;
        AiffChunkType chunkType = AiffChunkType.get(chunkHeader.getID());
        if (chunkType != null) {
            switch (chunkType) {
                case FORMAT_VERSION: {
                    chunk = new FormatVersionChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case APPLICATION: {
                    chunk = new ApplicationChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMON: {
                    chunk = new CommonChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMENTS: {
                    chunk = new CommentsChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case NAME: {
                    chunk = new NameChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case AUTHOR: {
                    chunk = new AuthorChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COPYRIGHT: {
                    chunk = new CopyrightChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case ANNOTATION: {
                    chunk = new AnnotationChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case SOUND: {
                    aiffAudioHeader.setAudioDataLength(chunkHeader.getSize());
                    aiffAudioHeader.setAudioDataStartPosition(fc.position());
                    aiffAudioHeader.setAudioDataEndPosition(fc.position() + chunkHeader.getSize());
                    chunk = null;
                    break;
                }
                default: {
                    chunk = null;
                    break;
                }
            }
        } else {
            chunk = null;
        }
        return chunk;
    }
}

