/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffAudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.iff.IffHeaderChunk;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.Hex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;

public class AiffFileHeader {
    private static final String FORM = "FORM";
    private static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AudioFileHeader");

    public long readHeader(FileChannel fc, AiffAudioHeader aiffAudioHeader, String fileName) throws IOException, CannotReadException {
        ByteBuffer headerData = ByteBuffer.allocateDirect(IffHeaderChunk.HEADER_LENGTH);
        headerData.order(ByteOrder.BIG_ENDIAN);
        int bytesRead = fc.read(headerData);
        headerData.position(0);
        if (bytesRead < IffHeaderChunk.HEADER_LENGTH) {
            throw new IOException(fileName + ":AIFF:Unable to read required number of databytes read:" + bytesRead + ":required:" + IffHeaderChunk.HEADER_LENGTH);
        }
        String signature = Utils.readFourBytesAsChars(headerData);
        if (FORM.equals(signature)) {
            long chunkSize = headerData.getInt();
            logger.config(fileName + ":Reading AIFF header size:" + Hex.asDecAndHex(chunkSize));
            this.readFileType(headerData, aiffAudioHeader);
            return chunkSize - (long)IffHeaderChunk.TYPE_LENGTH;
        }
        throw new CannotReadException(fileName + ":Not an AIFF file: incorrect signature " + signature);
    }

    private void readFileType(ByteBuffer bytes, AiffAudioHeader aiffAudioHeader) throws IOException, CannotReadException {
        String type = Utils.readFourBytesAsChars(bytes);
        if (AiffType.AIFF.getCode().equals(type)) {
            aiffAudioHeader.setFileType(AiffType.AIFF);
        } else if (AiffType.AIFC.getCode().equals(type)) {
            aiffAudioHeader.setFileType(AiffType.AIFC);
        } else {
            throw new CannotReadException("Invalid AIFF file: Incorrect file type info " + type);
        }
    }
}

