/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.aiff.AiffType;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.GenericAudioHeader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AiffAudioHeader
extends GenericAudioHeader {
    private AiffType fileType;
    private Date timestamp;
    private Endian endian;
    private String audioEncoding;
    private String name;
    private String author;
    private String copyright;
    private List<String> applicationIdentifiers = new ArrayList<String>();
    private List<String> comments = new ArrayList<String>();
    private List<String> annotations = new ArrayList<String>();

    public AiffAudioHeader() {
        this.endian = Endian.BIG_ENDIAN;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date d) {
        this.timestamp = d;
    }

    public AiffType getFileType() {
        return this.fileType;
    }

    public void setFileType(AiffType typ) {
        this.fileType = typ;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String c) {
        this.copyright = c;
    }

    public Endian getEndian() {
        return this.endian;
    }

    public void setEndian(Endian e) {
        this.endian = e;
    }

    public List<String> getApplicationIdentifiers() {
        return this.applicationIdentifiers;
    }

    public void addApplicationIdentifier(String id) {
        this.applicationIdentifiers.add(id);
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String a) {
        this.annotations.add(a);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void addComment(String c) {
        this.comments.add(c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        if (this.name != null && !this.name.isEmpty()) {
            sb.append("\tName:" + this.name + "\n");
        }
        if (this.author != null && !this.author.isEmpty()) {
            sb.append("\tAuthor:" + this.author + "\n");
        }
        if (this.copyright != null && !this.copyright.isEmpty()) {
            sb.append("\tCopyright:" + this.copyright + "\n");
        }
        if (this.comments.size() > 0) {
            sb.append("Comments:\n");
            for (String next : this.comments) {
                sb.append("\t" + next + "\n");
            }
        }
        if (this.applicationIdentifiers.size() > 0) {
            sb.append("ApplicationIds:\n");
            for (String next : this.applicationIdentifiers) {
                sb.append("\t" + next + "\n");
            }
        }
        if (this.annotations.size() > 0) {
            sb.append("Annotations:\n");
            for (String next : this.annotations) {
                sb.append("\t" + next + "\n");
            }
        }
        return super.toString() + sb.toString();
    }

    public static enum Endian {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

