/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.SupportedFileFormat;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Utils;
import java.io.File;
import java.io.FileFilter;

public class AudioFileFilter
implements FileFilter {
    private final boolean allowDirectories;

    public AudioFileFilter(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    public AudioFileFilter() {
        this(true);
    }

    @Override
    public boolean accept(File f) {
        if (f.isHidden() || !f.canRead()) {
            return false;
        }
        if (f.isDirectory()) {
            return this.allowDirectories;
        }
        String ext = Utils.getExtension(f);
        try {
            if (SupportedFileFormat.valueOf(ext.toUpperCase()) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return false;
    }
}

