/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.jaudiotagger.audio;

import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioFileIO;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.AudioHeader;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.SupportedFileFormat;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.dsf.Dsf;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotReadException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.CannotWriteException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.NoReadPermissionsException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.generic.Permissions;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.real.RealTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.logging.ErrorMessage;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.TagOptionSingleton;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.aiff.AiffTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.asf.AsfTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.flac.FlacTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.AbstractTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v22Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v23Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.id3.ID3v24Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.mp4.Mp4Tag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.reference.ID3V2Version;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import io.github.maki99999.biomebeats.org.jaudiotagger.tag.wav.WavTag;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AudioFile {
    public static Logger logger = Logger.getLogger("io.github.maki99999.biomebeats.org.jaudiotagger.audio");
    protected File file;
    protected AudioHeader audioHeader;
    protected Tag tag;
    protected String extension;

    public AudioFile() {
    }

    public AudioFile(File f, AudioHeader audioHeader, Tag tag) {
        this.file = f;
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public AudioFile(String s, AudioHeader audioHeader, Tag tag) {
        this.file = new File(s);
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public void commit() throws CannotWriteException {
        AudioFileIO.write(this);
    }

    public void delete() throws CannotReadException, CannotWriteException {
        AudioFileIO.delete(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setExt(String ext) {
        this.extension = ext;
    }

    public String getExt() {
        return this.extension;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public AudioHeader getAudioHeader() {
        return this.audioHeader;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "AudioFile " + this.getFile().getAbsolutePath() + "  --------\n" + this.audioHeader.toString() + "\n" + (this.tag == null ? "" : this.tag.toString()) + "\n-------------------";
    }

    public void checkFileExists(File file) throws FileNotFoundException {
        logger.config("Reading file:path" + file.getPath() + ":abs:" + file.getAbsolutePath());
        if (!file.exists()) {
            logger.severe("Unable to find:" + file.getPath());
            throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(file.getPath()));
        }
    }

    protected RandomAccessFile checkFilePermissions(File file, boolean readOnly) throws ReadOnlyFileException, FileNotFoundException, CannotReadException {
        RandomAccessFile newFile;
        Path path = file.toPath();
        this.checkFileExists(file);
        if (readOnly) {
            if (!Files.isReadable(path)) {
                logger.severe("Unable to read file:" + path);
                logger.severe(Permissions.displayPermissions(path));
                throw new NoReadPermissionsException(ErrorMessage.GENERAL_READ_FAILED_DO_NOT_HAVE_PERMISSION_TO_READ_FILE.getMsg(path));
            }
            newFile = new RandomAccessFile(file, "r");
        } else {
            if (TagOptionSingleton.getInstance().isCheckIsWritable() && !Files.isWritable(path)) {
                logger.severe(Permissions.displayPermissions(file.toPath()));
                logger.severe(Permissions.displayPermissions(path));
                throw new ReadOnlyFileException(ErrorMessage.NO_PERMISSIONS_TO_WRITE_TO_FILE.getMsg(path));
            }
            newFile = new RandomAccessFile(file, "rw");
        }
        return newFile;
    }

    public String displayStructureAsXML() {
        return "";
    }

    public String displayStructureAsPlainText() {
        return "";
    }

    public Tag createDefaultTag() {
        String extension = this.getExt();
        if (extension == null) {
            String fileName = this.file.getName();
            extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            this.setExt(extension);
        }
        if (SupportedFileFormat.FLAC.getFilesuffix().equals(extension)) {
            return new FlacTag(VorbisCommentTag.createNewTag(), new ArrayList<MetadataBlockDataPicture>());
        }
        if (SupportedFileFormat.OGG.getFilesuffix().equals(extension)) {
            return VorbisCommentTag.createNewTag();
        }
        if (SupportedFileFormat.MP4.getFilesuffix().equals(extension)) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.M4A.getFilesuffix().equals(extension)) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.M4P.getFilesuffix().equals(extension)) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.WMA.getFilesuffix().equals(extension)) {
            return new AsfTag();
        }
        if (SupportedFileFormat.WAV.getFilesuffix().equals(extension)) {
            return new WavTag(TagOptionSingleton.getInstance().getWavOptions());
        }
        if (SupportedFileFormat.RA.getFilesuffix().equals(extension)) {
            return new RealTag();
        }
        if (SupportedFileFormat.RM.getFilesuffix().equals(extension)) {
            return new RealTag();
        }
        if (SupportedFileFormat.AIF.getFilesuffix().equals(extension)) {
            return new AiffTag();
        }
        if (SupportedFileFormat.AIFC.getFilesuffix().equals(extension)) {
            return new AiffTag();
        }
        if (SupportedFileFormat.AIFF.getFilesuffix().equals(extension)) {
            return new AiffTag();
        }
        if (SupportedFileFormat.DSF.getFilesuffix().equals(extension)) {
            return Dsf.createDefaultTag();
        }
        throw new RuntimeException("Unable to create default tag for this file format");
    }

    public Tag getTagOrCreateDefault() {
        Tag tag = this.getTag();
        if (tag == null) {
            return this.createDefaultTag();
        }
        return tag;
    }

    public Tag getTagOrCreateAndSetDefault() {
        Tag tag = this.getTagOrCreateDefault();
        this.setTag(tag);
        return tag;
    }

    public Tag getTagAndConvertOrCreateDefault() {
        Tag tag = this.getTagOrCreateDefault();
        if (tag instanceof AbstractID3v2Tag) {
            AbstractID3v2Tag convertedTag = this.convertID3Tag((AbstractID3v2Tag)tag, TagOptionSingleton.getInstance().getID3V2Version());
            if (convertedTag != null) {
                return convertedTag;
            }
            return tag;
        }
        return tag;
    }

    public Tag getTagAndConvertOrCreateAndSetDefault() {
        Tag tag = this.getTagAndConvertOrCreateDefault();
        this.setTag(tag);
        return this.getTag();
    }

    public static String getBaseFilename(File file) {
        int index = file.getName().toLowerCase().lastIndexOf(".");
        if (index > 0) {
            return file.getName().substring(0, index);
        }
        return file.getName();
    }

    public AbstractID3v2Tag convertID3Tag(AbstractID3v2Tag tag, ID3V2Version id3V2Version) {
        if (tag instanceof ID3v24Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V24: {
                    return null;
                }
            }
        } else if (tag instanceof ID3v23Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v23Tag)tag));
                }
                case ID3_V23: {
                    return null;
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v23Tag)tag));
                }
            }
        } else if (tag instanceof ID3v22Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return null;
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v22Tag)tag));
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v22Tag)tag));
                }
            }
        }
        return null;
    }
}

