/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.IdleState;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WaitingBreakState
extends IdleState {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledFuture<?> breakTask;
    private final MusicTrack track;

    public WaitingBreakState(JavaStreamPlayer context, MusicTrack track) {
        super(context);
        this.track = track;
        this.ctx.unsetCurrentSong();
        this.breakTask = scheduler.schedule(() -> super.play(track), (long)Constants.CONFIG_IO.getGeneralConfig().getBreakTime(), TimeUnit.SECONDS);
    }

    @Override
    public void play(MusicTrack song) {
        this.cancelTask();
        super.play(song);
    }

    @Override
    public void pause() {
        this.cancelTask();
        this.ctx.openPlay(this.track);
        this.ctx.setStatePause();
    }

    @Override
    public void stop() {
        this.cancelTask();
        this.ctx.setStateIdle();
    }

    @Override
    public String getName() {
        return "Waiting Break";
    }

    private void cancelTask() {
        if (this.breakTask != null) {
            this.breakTask.cancel(true);
        }
    }

    @Override
    public void close() {
        this.breakTask.cancel(true);
    }
}

