/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;

public class PausedState
extends PlayerState {
    public PausedState(JavaStreamPlayer ctx) {
        super(ctx);
        ctx.getPlayer().pause();
    }

    public PausedState(JavaStreamPlayer ctx, MusicTrack track) {
        super(ctx);
        ctx.stopOpenPlayPause(track);
    }

    @Override
    public void play(MusicTrack song) {
        this.ctx.setStateFadeIn(song);
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
        this.ctx.setStateIdle();
    }

    @Override
    public void resume() {
        this.ctx.setStateFadeIn(this.ctx.getCurrentSong());
    }

    @Override
    public void musicEnded(MusicTrack nextSong) {
        this.ctx.stopOpenPlayPause(nextSong);
    }

    @Override
    public String getName() {
        return "Paused";
    }

    @Override
    public void close() {
    }
}

