/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.music.statemachine.PlaybackIntent;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;

public class MusicState
extends PlayerState {
    public MusicState(JavaStreamPlayer ctx) {
        super(ctx);
    }

    public MusicState(JavaStreamPlayer ctx, MusicTrack track) {
        super(ctx);
        if (track.equals(ctx.getCurrentSong())) {
            return;
        }
        ctx.setCurrentGain(ctx.getBaseTargetGain() * track.getVolumeMultiplier());
        ctx.openPlay(track);
    }

    @Override
    public void play(MusicTrack song) {
        if (!song.equals(this.ctx.getCurrentSong())) {
            this.ctx.setStateFadeOut(new PlaybackIntent.Play(song));
        }
    }

    @Override
    public void pause() {
        this.ctx.setStateFadeOut(new PlaybackIntent.Pause());
    }

    @Override
    public void stop() {
        this.ctx.setStateFadeOut(new PlaybackIntent.Stop());
    }

    @Override
    public void resume() {
        JavaStreamPlayer.suspiciousTransition(this.getName(), "resume");
    }

    @Override
    public void musicEnded(MusicTrack nextSong) {
        this.ctx.setStateWaitingBreak(nextSong);
    }

    @Override
    public String getName() {
        return "Music";
    }

    @Override
    public void close() {
    }
}

