/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayer;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerException;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerListener;
import io.github.maki99999.biomebeats.music.FileMusicTrack;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.ResourceLocationMusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.FadeInState;
import io.github.maki99999.biomebeats.music.statemachine.FadeOutState;
import io.github.maki99999.biomebeats.music.statemachine.IdleState;
import io.github.maki99999.biomebeats.music.statemachine.MusicState;
import io.github.maki99999.biomebeats.music.statemachine.PausedState;
import io.github.maki99999.biomebeats.music.statemachine.PlaybackIntent;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;
import io.github.maki99999.biomebeats.music.statemachine.WaitingBreakState;
import io.github.maki99999.biomebeats.service.Services;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class JavaStreamPlayer {
    private final String name;
    private final StreamPlayer player;
    private final ExecutorService mainExecutor;
    private final StateLogger debugLogger;
    private final Object gainLock = new Object();
    private Thread mainExecutorThread = null;
    @NotNull
    private PlayerState state;
    private double baseTargetGain;
    private double targetGain;
    private double currentGain = this.targetGain = (this.baseTargetGain = 1.0);
    private MusicTrack currentSong = null;

    public JavaStreamPlayer(String name) {
        this.name = name;
        this.mainExecutor = Executors.newSingleThreadExecutor(r -> {
            this.mainExecutorThread = new Thread(r);
            this.mainExecutorThread.setName("BiomeBeats-StreamPlayerThread-" + name);
            this.mainExecutorThread.setDaemon(true);
            return this.mainExecutorThread;
        });
        this.debugLogger = Services.PLATFORM.isDevelopmentEnvironment() ? arg_0 -> ((Logger)Constants.LOG).debug(arg_0) : null;
        java.util.logging.Logger.getLogger(StreamPlayer.class.getName()).setLevel(Level.OFF);
        this.player = new StreamPlayer();
        this.state = new IdleState(this);
    }

    static void suspiciousTransition(String stateName, String signalName) {
        Constants.LOG.warn("Suspicious transition: {} {}", (Object)stateName, (Object)signalName);
    }

    public void runOnMain(Runnable runnable) {
        if (Thread.currentThread() == this.mainExecutorThread) {
            runnable.run();
        } else {
            this.mainExecutor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getCurrentGain() {
        Object object = this.gainLock;
        synchronized (object) {
            return this.currentGain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentGain(double currentGain) {
        Object object = this.gainLock;
        synchronized (object) {
            this.currentGain = currentGain;
        }
    }

    double getTargetGain() {
        return this.targetGain;
    }

    double getBaseTargetGain() {
        return this.baseTargetGain;
    }

    public void setTargetGain(double targetGain) {
        this.baseTargetGain = targetGain;
        double newTargetGain = this.baseTargetGain * (this.currentSong == null ? 1.0 : this.currentSong.getVolumeMultiplier());
        if (newTargetGain == this.targetGain) {
            return;
        }
        this.targetGain = newTargetGain;
        this.runOnMain(() -> {
            if (!this.state.controlsGain()) {
                Object object = this.gainLock;
                synchronized (object) {
                    this.currentGain = this.targetGain;
                }
                this.player.setGain(this.currentGain);
            }
        });
    }

    MusicTrack getCurrentSong() {
        return this.currentSong;
    }

    void unsetCurrentSong() {
        this.currentSong = null;
    }

    StreamPlayer getPlayer() {
        return this.player;
    }

    StateLogger getDebugLogger() {
        return this.debugLogger;
    }

    public void close() {
        this.state.close();
        this.stopAndResetGain();
        this.player.reset();
        this.mainExecutor.shutdownNow();
    }

    public void addStreamPlayerListener(StreamPlayerListener listener) {
        this.player.addStreamPlayerListener(listener);
    }

    public String getDebugString() {
        return "%s S: %s C: %.3f T: %.3f".formatted(this.name, this.state.getName(), this.currentGain, this.targetGain);
    }

    public void play(MusicTrack song) {
        this.runOnMain(() -> {
            this.logTransition("play");
            this.state.play(song);
        });
    }

    public void pause() {
        this.runOnMain(() -> {
            this.logTransition("pause");
            this.state.pause();
        });
    }

    public void stop() {
        this.runOnMain(() -> {
            this.logTransition("stop");
            this.state.stop();
        });
    }

    public void resume() {
        this.runOnMain(() -> {
            this.logTransition("resume");
            this.state.resume();
        });
    }

    public void resumeIfPausedOrPausing() {
        this.runOnMain(() -> {
            FadeOutState fadeOutState;
            PlayerState patt4850$temp;
            if (this.state instanceof PausedState || (patt4850$temp = this.state) instanceof FadeOutState && (fadeOutState = (FadeOutState)patt4850$temp).isPausing()) {
                this.resume();
            }
        });
    }

    public void musicEnded(MusicTrack nextSong) {
        this.runOnMain(() -> {
            this.logTransition("musicEnded");
            this.state.musicEnded(nextSong);
        });
    }

    public void openPlay(MusicTrack musicTrack) {
        this.runOnMain(() -> {
            this.currentSong = musicTrack;
            this.targetGain = this.baseTargetGain * musicTrack.getVolumeMultiplier();
            Minecraft minecraft = Minecraft.m_91087_();
            if (musicTrack instanceof ResourceLocationMusicTrack) {
                ResourceLocationMusicTrack rlMusicTrack = (ResourceLocationMusicTrack)musicTrack;
                ResourceLocation fileResourceLocation = Sound.f_244492_.m_245698_(rlMusicTrack.getResourceLocation());
                Optional optionalResource = minecraft.m_91098_().m_213713_(fileResourceLocation);
                if (optionalResource.isPresent()) {
                    try {
                        this.player.open(new BufferedInputStream(((Resource)optionalResource.get()).m_215507_()));
                        this.player.play();
                        this.player.setGain(this.currentGain);
                    }
                    catch (StreamPlayerException | IOException e) {
                        Constants.LOG.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    Constants.LOG.error("Resource not found: {}", (Object)rlMusicTrack);
                }
            } else if (musicTrack instanceof FileMusicTrack) {
                FileMusicTrack fileMusicTrack = (FileMusicTrack)musicTrack;
                try {
                    this.player.open(fileMusicTrack.getFile());
                    this.player.play();
                    this.player.setGain(this.currentGain);
                }
                catch (StreamPlayerException e) {
                    Constants.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    void stopAndResetGain() {
        this.runOnMain(() -> {
            this.player.stop();
            Object object = this.gainLock;
            synchronized (object) {
                this.currentGain = 0.0;
            }
            this.player.setGain(this.currentGain);
        });
    }

    void stopOpenPlayPause(MusicTrack track) {
        this.stopAndResetGain();
        this.openPlay(track);
        this.player.pause();
    }

    void setStateFadeIn(MusicTrack track) {
        this.setState(new FadeInState(this, track));
    }

    void setStateFadeOut(PlaybackIntent queue) {
        this.setState(new FadeOutState(this, queue));
    }

    void setStateIdle() {
        this.setState(new IdleState(this));
    }

    void setStatePause() {
        this.setState(new PausedState(this));
    }

    void setStatePause(MusicTrack track) {
        this.setState(new PausedState(this, track));
    }

    void setStateMusic() {
        this.setState(new MusicState(this));
    }

    void setStateMusic(MusicTrack track) {
        this.setState(new MusicState(this, track));
    }

    void setStateWaitingBreak(MusicTrack nextSong) {
        this.setState(new WaitingBreakState(this, nextSong));
    }

    private void setState(PlayerState newState) {
        this.runOnMain(() -> {
            if (this.debugLogger != null) {
                this.debugLogger.log("%s - Current State: %s, New State: %s".formatted(this.name, this.state.getName(), newState.getName()));
            }
            this.state.close();
            this.state = newState;
        });
    }

    private void logTransition(String transition) {
        if (this.debugLogger != null) {
            this.debugLogger.log("%s - Current State: %s, New Transition: %s".formatted(this.name, this.state.getName(), transition));
        }
    }

    public static interface StateLogger {
        public void log(String var1);
    }
}

