/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;

public class IdleState
extends PlayerState {
    public IdleState(JavaStreamPlayer context) {
        super(context);
        this.ctx.unsetCurrentSong();
        this.ctx.stopAndResetGain();
    }

    @Override
    public void play(MusicTrack song) {
        this.ctx.setStateMusic(song);
    }

    @Override
    public void pause() {
        JavaStreamPlayer.suspiciousTransition(this.getName(), "pause");
    }

    @Override
    public void stop() {
    }

    @Override
    public void resume() {
        JavaStreamPlayer.suspiciousTransition(this.getName(), "resume");
    }

    @Override
    public void musicEnded(MusicTrack nextSong) {
        JavaStreamPlayer.suspiciousTransition(this.getName(), "musicEnded");
    }

    @Override
    public String getName() {
        return "Idle";
    }

    @Override
    public void close() {
    }
}

