/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.FadeHelper;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.music.statemachine.PlaybackIntent;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FadeOutState
extends PlayerState {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Future<?> fadeTask;
    private PlaybackIntent queue;

    FadeOutState(JavaStreamPlayer ctx, PlaybackIntent queue) {
        super(ctx);
        this.queue = queue;
        this.fadeTask = this.executorService.submit(() -> FadeHelper.fade(false, this::processQueue, ctx));
    }

    @Override
    public void play(MusicTrack song) {
        if (Objects.equals(song, this.ctx.getCurrentSong())) {
            this.ctx.setStateFadeIn(this.ctx.getCurrentSong());
        } else {
            this.queue = new PlaybackIntent.Play(song);
        }
    }

    @Override
    public void pause() {
        PlaybackIntent.Play playIntent;
        PlaybackIntent playbackIntent = this.queue;
        if (playbackIntent instanceof PlaybackIntent.Play && (playIntent = (PlaybackIntent.Play)playbackIntent).song() != this.ctx.getCurrentSong()) {
            this.queue = new PlaybackIntent.PauseWithSong(playIntent.song());
        } else if (!(this.queue instanceof PlaybackIntent.Pause)) {
            this.queue = new PlaybackIntent.Pause();
        }
    }

    @Override
    public void stop() {
        this.queue = new PlaybackIntent.Stop();
    }

    @Override
    public void resume() {
        this.ctx.setStateFadeIn(this.ctx.getCurrentSong());
    }

    void processQueue() {
        if (this.queue instanceof PlaybackIntent.Stop) {
            this.ctx.setStateIdle();
        } else if (this.queue instanceof PlaybackIntent.Pause) {
            this.ctx.setStatePause();
        } else {
            PlaybackIntent playbackIntent = this.queue;
            if (playbackIntent instanceof PlaybackIntent.PauseWithSong) {
                PlaybackIntent.PauseWithSong intent = (PlaybackIntent.PauseWithSong)playbackIntent;
                this.ctx.setStatePause(intent.song());
            } else {
                playbackIntent = this.queue;
                if (playbackIntent instanceof PlaybackIntent.Play) {
                    PlaybackIntent.Play intent = (PlaybackIntent.Play)playbackIntent;
                    this.ctx.setStateFadeIn(intent.song());
                }
            }
        }
    }

    @Override
    public void musicEnded(MusicTrack nextSong) {
        if (this.queue instanceof PlaybackIntent.Pause) {
            this.ctx.stopOpenPlayPause(nextSong);
        }
        this.cancelFadeTask();
        this.processQueue();
    }

    @Override
    public String getName() {
        return "Fade Out";
    }

    @Override
    public boolean controlsGain() {
        return true;
    }

    public boolean isPausing() {
        return this.queue != null && this.queue instanceof PlaybackIntent.Pause;
    }

    void cancelFadeTask() {
        if (this.fadeTask != null && !this.fadeTask.isDone()) {
            this.fadeTask.cancel(true);
        }
    }

    @Override
    public void close() {
        this.fadeTask.cancel(true);
        this.executorService.shutdownNow();
    }
}

