/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music.statemachine;

import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.FadeHelper;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.music.statemachine.PlaybackIntent;
import io.github.maki99999.biomebeats.music.statemachine.PlayerState;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FadeInState
extends PlayerState {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    Future<?> fadeTask;

    public FadeInState(JavaStreamPlayer ctx, MusicTrack track) {
        super(ctx);
        if (!Objects.equals(track, ctx.getCurrentSong())) {
            ctx.stopAndResetGain();
            ctx.openPlay(track);
        } else {
            ctx.getPlayer().resume();
        }
        this.fadeTask = this.executorService.submit(() -> FadeHelper.fade(true, ctx::setStateMusic, ctx));
    }

    @Override
    public void play(MusicTrack song) {
        if (!Objects.equals(song, this.ctx.getCurrentSong())) {
            this.ctx.setStateFadeOut(new PlaybackIntent.Play(song));
        }
    }

    @Override
    public void pause() {
        this.ctx.setStatePause();
    }

    @Override
    public void stop() {
        this.ctx.setStateFadeOut(new PlaybackIntent.Stop());
    }

    @Override
    public void resume() {
        JavaStreamPlayer.suspiciousTransition(this.getName(), "resume");
    }

    @Override
    public void musicEnded(MusicTrack nextSong) {
        this.cancelFadeTask();
        this.ctx.setStateWaitingBreak(nextSong);
    }

    @Override
    public String getName() {
        return "Fade In";
    }

    @Override
    public boolean controlsGain() {
        return true;
    }

    void cancelFadeTask() {
        if (this.fadeTask != null && !this.fadeTask.isDone()) {
            this.fadeTask.cancel(true);
        }
    }

    @Override
    public void close() {
        this.fadeTask.cancel(true);
        this.executorService.shutdownNow();
    }
}

