/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.enums.Status;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerEvent;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerListener;
import io.github.maki99999.biomebeats.config.ConfigChangeListener;
import io.github.maki99999.biomebeats.config.MainConfig;
import io.github.maki99999.biomebeats.config.MusicTrackConfig;
import io.github.maki99999.biomebeats.event.MusicTrackUpdateEvent;
import io.github.maki99999.biomebeats.mixin.MixinWeighedSoundEvents;
import io.github.maki99999.biomebeats.music.FileMusicTrack;
import io.github.maki99999.biomebeats.music.MusicGroup;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.PreviewListener;
import io.github.maki99999.biomebeats.music.ResourceLocationMusicTrack;
import io.github.maki99999.biomebeats.music.statemachine.JavaStreamPlayer;
import io.github.maki99999.biomebeats.service.Services;
import io.github.maki99999.biomebeats.util.EventBus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class MusicManager
implements StreamPlayerListener,
ConfigChangeListener {
    private static final Collection<String> SUPPORTED_FILE_EXTENSIONS = List.of("wav", "au", "aiff", "aif", "aifc", "mp3", "ogg", "flac", "ape", "spx");
    private final RandomSource rdm = RandomSource.m_216327_();
    private final List<MusicTrack> recentMusicTracks = new ArrayList<MusicTrack>();
    private final Collection<PreviewListener> previewListeners = new ArrayList<PreviewListener>();
    private JavaStreamPlayer javaStreamPlayer;
    private Collection<MusicTrack> musicTracks = null;
    private Collection<MusicGroup> musicGroups = null;
    private MusicTrack currentMusicTrack = null;
    private Collection<MusicTrack> currentMusicTracks = new HashSet<MusicTrack>();
    private JavaStreamPlayer previewJavaStreamPlayer;
    private MusicTrack currentPreviewTrack;
    private boolean inPreviewMode = false;

    public void init() {
        this.javaStreamPlayer = new JavaStreamPlayer("MAIN");
        this.javaStreamPlayer.addStreamPlayerListener(this);
        this.initPreviewPlayer();
        this.updateVolume();
        this.findMusicTracksAndGroups();
        Constants.CONFIG_IO.addListener(this);
        EventBus.subscribe(MusicTrackUpdateEvent.class, this::musicTrackUpdated);
    }

    private void initPreviewPlayer() {
        this.previewJavaStreamPlayer = new JavaStreamPlayer("PREVIEW");
        this.previewJavaStreamPlayer.addStreamPlayerListener(new StreamPlayerListener(){

            @Override
            public void opened(Object dataSource, Map<String, Object> properties) {
                Constants.LOG.debug("Opened preview stream player {}", dataSource);
            }

            @Override
            public void progress(int nEncodedBytes, long microsecondPosition, byte[] pcmData, Map<String, Object> properties) {
            }

            @Override
            public void statusUpdated(StreamPlayerEvent event) {
                Status status = event.getPlayerStatus();
                Constants.LOG.debug("New preview music player status: {}", (Object)status.name());
                if (status == Status.EOM) {
                    MusicManager.this.currentPreviewTrack = null;
                    MusicManager.this.previewListeners.forEach(listener -> listener.onPreviewChanged(null));
                }
            }
        });
    }

    public void reloadMusicTracksAndGroups() {
        this.findMusicTracksAndGroups();
    }

    public void playPreviewTrack(MusicTrack musicTrack) {
        this.previewJavaStreamPlayer.play(musicTrack);
        this.currentPreviewTrack = musicTrack;
        this.previewListeners.forEach(listener -> listener.onPreviewChanged(musicTrack));
    }

    public String getDebugString1() {
        return this.javaStreamPlayer.getDebugString();
    }

    public String getDebugString2() {
        return this.previewJavaStreamPlayer.getDebugString();
    }

    public void stopPreviewTrack() {
        this.previewJavaStreamPlayer.stop();
    }

    public void startPreviewMode() {
        this.pause();
        this.inPreviewMode = true;
    }

    public void stopPreviewMode() {
        this.stopPreviewTrack();
        this.inPreviewMode = false;
    }

    public void addPreviewListener(PreviewListener listener) {
        this.previewListeners.add(listener);
        listener.onPreviewChanged(this.currentPreviewTrack);
    }

    public void removePreviewListener(PreviewListener listener) {
        this.previewListeners.remove(listener);
    }

    public void close() {
        if (this.javaStreamPlayer != null) {
            this.javaStreamPlayer.close();
        }
    }

    public void setCurrentMusicTracks(Collection<MusicTrack> musicTracks) {
        this.currentMusicTracks = musicTracks;
        Constants.LOG.debug("Songs: {}", (Object)String.join((CharSequence)", ", musicTracks.stream().map(MusicTrack::getName).toList()));
        if (!musicTracks.contains(this.currentMusicTrack)) {
            this.playNext(false);
        } else if (!this.inPreviewMode) {
            this.javaStreamPlayer.resumeIfPausedOrPausing();
        }
    }

    public void play(MusicTrack musicTrack) {
        this.javaStreamPlayer.play(musicTrack);
        if (this.inPreviewMode) {
            this.javaStreamPlayer.pause();
        }
    }

    public void stop() {
        this.javaStreamPlayer.stop();
    }

    public void pause() {
        this.javaStreamPlayer.pause();
    }

    public void resume() {
        this.javaStreamPlayer.resume();
    }

    public void updateVolume() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.setVolume(minecraft.f_91066_.m_92147_(SoundSource.MASTER) * minecraft.f_91066_.m_92147_(SoundSource.MUSIC));
    }

    public void setVolume(float volume) {
        this.javaStreamPlayer.setTargetGain(volume * 0.5f);
        this.previewJavaStreamPlayer.setTargetGain(volume * 0.5f);
    }

    public Collection<? extends MusicTrack> getMusicTracks() {
        if (this.musicTracks == null) {
            Constants.LOG.error("Music tracks are not initialized yet!");
        }
        return this.musicTracks;
    }

    public Collection<MusicGroup> getMusicGroups() {
        if (this.musicGroups == null) {
            Constants.LOG.error("Music groups are not initialized yet!");
        }
        return this.musicGroups;
    }

    @Override
    public void opened(Object dataSource, Map<String, Object> properties) {
        Constants.LOG.debug("Opened stream player {}", dataSource);
    }

    @Override
    public void progress(int nEncodedBytes, long microsecondPosition, byte[] pcmData, Map<String, Object> properties) {
    }

    @Override
    public void statusUpdated(StreamPlayerEvent event) {
        Status status = event.getPlayerStatus();
        Constants.LOG.debug("New music player status: {}", (Object)status.name());
        if (status == Status.EOM) {
            this.playNext(true);
        }
    }

    public MusicTrack getCurrentMusicTrack() {
        return this.currentMusicTrack;
    }

    private void playNext(boolean fromEom) {
        if (this.currentMusicTracks == null || this.currentMusicTracks.isEmpty()) {
            this.currentMusicTrack = null;
            this.javaStreamPlayer.stop();
            return;
        }
        Collection<MusicTrack> nonRecentMusicTracks = this.currentMusicTracks.stream().filter(o -> !this.recentMusicTracks.contains(o)).toList();
        if (nonRecentMusicTracks.isEmpty()) {
            nonRecentMusicTracks = this.currentMusicTracks;
        }
        this.currentMusicTrack = (MusicTrack)nonRecentMusicTracks.stream().skip(this.rdm.m_216339_(0, nonRecentMusicTracks.size())).findAny().orElseThrow();
        this.addRecentMusicTrack(this.currentMusicTrack);
        if (fromEom) {
            this.javaStreamPlayer.musicEnded(this.currentMusicTrack);
        } else {
            this.javaStreamPlayer.play(this.currentMusicTrack);
        }
        if (this.inPreviewMode) {
            this.javaStreamPlayer.pause();
        }
    }

    private void addRecentMusicTrack(MusicTrack musicTrack) {
        this.recentMusicTracks.remove(musicTrack);
        this.recentMusicTracks.add(0, musicTrack);
        if (this.recentMusicTracks.size() > 5) {
            this.recentMusicTracks.remove(this.recentMusicTracks.size() - 1);
        }
    }

    private void findMusicTracksAndGroups() {
        List<FileMusicTrack> fileMusicTracks;
        Minecraft minecraft = Minecraft.m_91087_();
        TreeMap<String, Map> music = new TreeMap<String, Map>();
        this.musicGroups = new ArrayList<MusicGroup>();
        this.musicTracks = new HashSet<MusicTrack>();
        try {
            Files.createDirectories(Services.PLATFORM.getModConfigFolder().resolve("music"), new FileAttribute[0]);
            Path musicFolder = Services.PLATFORM.getModConfigFolder().resolve("music");
            try (Stream<Path> stream = Files.list(musicFolder);){
                fileMusicTracks = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                    String fileName = path.getFileName().toString().toLowerCase();
                    return SUPPORTED_FILE_EXTENSIONS.stream().anyMatch(fileName::endsWith);
                }).map(path -> new FileMusicTrack(path.getFileName().toString())).toList();
            }
        }
        catch (Exception e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
            fileMusicTracks = List.of();
        }
        this.musicGroups.add(new MusicGroup(fileMusicTracks));
        this.musicTracks.addAll(fileMusicTracks);
        for (ResourceLocation resourceLocation2 : BuiltInRegistries.f_256894_.m_6566_()) {
            if (resourceLocation2.m_135815_().contains("music.")) {
                music.computeIfAbsent(resourceLocation2.m_135827_(), k -> new HashMap()).computeIfAbsent(MusicGroup.Type.BGM, k -> new ArrayList()).add(resourceLocation2);
                continue;
            }
            if (!resourceLocation2.m_135815_().contains("music_disc.")) continue;
            music.computeIfAbsent(resourceLocation2.m_135827_(), k -> new HashMap()).computeIfAbsent(MusicGroup.Type.MUSIC_DISC, k -> new ArrayList()).add(resourceLocation2);
        }
        for (Map.Entry entry : music.entrySet()) {
            for (Map.Entry musicByTypeEntry : ((Map)entry.getValue()).entrySet()) {
                List<ResourceLocation> resourceLocations = ((Collection)musicByTypeEntry.getValue()).stream().map(resourceLocation -> (MixinWeighedSoundEvents)minecraft.m_91106_().m_120384_(resourceLocation)).filter(Objects::nonNull).flatMap(soundEvents -> soundEvents.list().stream()).map(weightedSound -> (Sound)weightedSound.m_213718_(this.rdm)).map(Sound::m_119787_).distinct().toList();
                List<ResourceLocationMusicTrack> groupMusicTracks = resourceLocations.stream().map(ResourceLocationMusicTrack::new).toList();
                this.musicGroups.add(new MusicGroup((String)entry.getKey(), (MusicGroup.Type)((Object)musicByTypeEntry.getKey()), groupMusicTracks));
                this.musicTracks.addAll(groupMusicTracks);
            }
        }
    }

    @Override
    public void beforeConfigChange(MainConfig config) {
        Map<String, MusicTrackConfig> musicTrackConfigById = config.getMusicTrackConfigById();
        for (MusicTrack musicTrack : this.musicTracks) {
            MusicTrackConfig musicTrackConfig = musicTrackConfigById.computeIfAbsent(musicTrack.getId(), k -> new MusicTrackConfig());
            musicTrackConfig.setCustomName(musicTrack.getCustomName());
            musicTrackConfig.setVolumeMultiplier(musicTrack.getVolumeMultiplier());
        }
    }

    @Override
    public void afterConfigChange(MainConfig config) {
        if (this.musicTracks == null) {
            Constants.LOG.error("Config loaded before music tracks initialized!");
            return;
        }
        Map<String, MusicTrackConfig> musicTrackConfigById = config.getMusicTrackConfigById();
        for (MusicTrack musicTrack : this.musicTracks) {
            if (!musicTrackConfigById.containsKey(musicTrack.getId())) continue;
            MusicTrackConfig musicTrackConfig = musicTrackConfigById.get(musicTrack.getId());
            musicTrack.setCustomName(musicTrackConfig.getCustomName());
            musicTrack.setVolumeMultiplier(musicTrackConfig.getVolumeMultiplier());
        }
    }

    private void musicTrackUpdated(MusicTrackUpdateEvent e) {
        if (e.musicTrack().equals(this.currentMusicTrack) || e.musicTrack().equals(this.currentPreviewTrack)) {
            this.updateVolume();
        }
    }
}

