/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music;

import io.github.maki99999.biomebeats.music.FileMusicTrack;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.util.StringUtils;
import java.util.Collection;
import net.minecraft.client.resources.language.I18n;

public final class MusicGroup {
    private final String name;
    private Type type;
    private final Collection<? extends MusicTrack> musicTracks;

    public MusicGroup(String namespace, Type type, Collection<? extends MusicTrack> musicTracks) {
        this.name = StringUtils.formatToTitleCase(namespace);
        this.type = type;
        this.musicTracks = musicTracks;
    }

    public MusicGroup(Collection<FileMusicTrack> musicTracks) {
        this.name = null;
        this.type = Type.CUSTOM;
        this.musicTracks = musicTracks;
    }

    public MusicGroup(String name, Collection<? extends MusicTrack> musicTracks) {
        this.name = name;
        this.musicTracks = musicTracks;
    }

    public String getName() {
        if (this.name != null && this.type == null) {
            return this.name;
        }
        if (this.name == null && this.type != null) {
            return I18n.m_118938_((String)this.type.getTranslationKey(), (Object[])new Object[0]);
        }
        if (this.name != null) {
            return "%s (%s)".formatted(this.name, I18n.m_118938_((String)this.type.getTranslationKey(), (Object[])new Object[0]));
        }
        return "";
    }

    public Collection<? extends MusicTrack> getMusicTracks() {
        return this.musicTracks;
    }

    public static enum Type {
        BGM("menu.biomebeats.categories.bgm"),
        MUSIC_DISC("menu.biomebeats.categories.music_disc"),
        CUSTOM("menu.biomebeats.categories.custom"),
        UNKNOWN("menu.biomebeats.categories.others");

        private final String translationKey;

        private Type(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

