/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.music;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayer {
    public void play(String filePath) {
        try {
            File audioFile = new File(filePath);
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(audioFile);
            Clip audioClip = AudioSystem.getClip();
            audioClip.open(audioStream);
            audioClip.start();
            System.out.println("Playing audio...");
            Thread.sleep(audioClip.getMicrosecondLength() / 1000L);
        }
        catch (UnsupportedAudioFileException e) {
            System.out.println("The specified audio file is not supported.");
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            System.out.println("Audio line for playing back is unavailable.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error playing the audio file.");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.out.println("Playback interrupted.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AudioPlayer player = new AudioPlayer();
        player.play("G:\\User\\Music\\Test.wav");
    }
}

