/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.util.Rect;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class DrawUtils {
    public static void drawRect(ResourceLocation resourceLocation, GuiGraphics guiGraphics, Rect pos, Rect uv) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f lastPose = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(lastPose, (float)pos.x1(), (float)pos.y1(), 0.0f).m_7421_((float)uv.x1() / 256.0f, (float)uv.y1() / 256.0f).m_5752_();
        bufferBuilder.m_252986_(lastPose, (float)pos.x1(), (float)pos.y2(), 0.0f).m_7421_((float)uv.x1() / 256.0f, (float)uv.y2() / 256.0f).m_5752_();
        bufferBuilder.m_252986_(lastPose, (float)pos.x2(), (float)pos.y2(), 0.0f).m_7421_((float)uv.x2() / 256.0f, (float)uv.y2() / 256.0f).m_5752_();
        bufferBuilder.m_252986_(lastPose, (float)pos.x2(), (float)pos.y1(), 0.0f).m_7421_((float)uv.x2() / 256.0f, (float)uv.y1() / 256.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void drawNineSliceRect(ResourceLocation rl, GuiGraphics guiGraphics, Rect bounds, Rect uv, Rect innerUv) {
        Padding padding = DrawUtils.getPadding(uv, innerUv);
        DrawUtils.drawNineSliceRectCorners(rl, guiGraphics, bounds, uv, innerUv, padding);
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1(), bounds.y1() + padding.top(), padding.left(), bounds.h() - padding.top() - padding.bottom()), Rect.fromCoordinates(uv.x1(), innerUv.y1(), innerUv.x1(), innerUv.y2()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x2() - padding.right(), bounds.y1() + padding.top(), padding.right(), bounds.h() - padding.top() - padding.bottom()), Rect.fromCoordinates(innerUv.x2(), innerUv.y1(), uv.x2(), innerUv.y2()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left(), bounds.y1(), bounds.w() - padding.left() - padding.right(), padding.top()), Rect.fromCoordinates(innerUv.x1(), uv.y1(), innerUv.x2(), innerUv.y1()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left(), bounds.y2() - padding.bottom(), bounds.w() - padding.left() - padding.right(), padding.bottom()), Rect.fromCoordinates(innerUv.x1(), innerUv.y2(), innerUv.x2(), uv.y2()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left(), bounds.y1() + padding.top(), bounds.w() - padding.left() - padding.right(), bounds.h() - padding.top() - padding.bottom()), Rect.fromCoordinates(innerUv.x1(), innerUv.y1(), innerUv.x2(), innerUv.y2()));
    }

    private static void drawNineSliceRectCorners(ResourceLocation rl, GuiGraphics guiGraphics, Rect bounds, Rect uv, Rect innerUv, Padding padding) {
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1(), bounds.y1(), padding.left(), padding.top()), Rect.fromCoordinates(uv.x1(), uv.y1(), innerUv.x1(), innerUv.y1()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x2() - padding.right(), bounds.y1(), padding.right(), padding.top()), Rect.fromCoordinates(innerUv.x2(), uv.y1(), uv.x2(), innerUv.y1()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1(), bounds.y2() - padding.bottom(), padding.left(), padding.bottom()), Rect.fromCoordinates(uv.x1(), innerUv.y2(), innerUv.x1(), uv.y2()));
        DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x2() - padding.right(), bounds.y2() - padding.bottom(), padding.right(), padding.bottom()), Rect.fromCoordinates(innerUv.x2(), innerUv.y2(), uv.x2(), uv.y2()));
    }

    public static void drawTiledNineSliceRect(ResourceLocation rl, GuiGraphics guiGraphics, Rect bounds, Rect uv, Rect innerUv) {
        int tileW;
        int x;
        Padding padding = DrawUtils.getPadding(uv, innerUv);
        DrawUtils.drawNineSliceRectCorners(rl, guiGraphics, bounds, uv, innerUv, padding);
        int centerWidth = innerUv.w();
        int centerHeight = innerUv.h();
        int innerW = bounds.w() - padding.left() - padding.right();
        int innerH = bounds.h() - padding.top() - padding.bottom();
        for (x = 0; x < innerW; x += centerWidth) {
            tileW = Math.min(centerWidth, innerW - x);
            DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left() + x, bounds.y1(), tileW, padding.top()), Rect.fromCoordinates(innerUv.x1(), uv.y1(), innerUv.x1() + tileW, innerUv.y1()));
            DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left() + x, bounds.y2() - padding.bottom(), tileW, padding.bottom()), Rect.fromCoordinates(innerUv.x1(), innerUv.y2(), innerUv.x1() + tileW, uv.y2()));
        }
        for (int y = 0; y < innerH; y += centerHeight) {
            int tileH = Math.min(centerHeight, innerH - y);
            DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1(), bounds.y1() + padding.top() + y, padding.left(), tileH), Rect.fromCoordinates(uv.x1(), innerUv.y1(), innerUv.x1(), innerUv.y1() + tileH));
            DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x2() - padding.right(), bounds.y1() + padding.top() + y, padding.right(), tileH), Rect.fromCoordinates(innerUv.x2(), innerUv.y1(), uv.x2(), innerUv.y1() + tileH));
        }
        for (x = 0; x < innerW; x += centerWidth) {
            tileW = Math.min(centerWidth, innerW - x);
            for (int y = 0; y < innerH; y += centerHeight) {
                int tileH = Math.min(centerHeight, innerH - y);
                DrawUtils.drawRect(rl, guiGraphics, new Rect(bounds.x1() + padding.left() + x, bounds.y1() + padding.top() + y, tileW, tileH), Rect.fromCoordinates(innerUv.x1(), innerUv.y1(), innerUv.x1() + tileW, innerUv.y1() + tileH));
            }
        }
    }

    @NotNull
    private static Padding getPadding(Rect uv, Rect innerUv) {
        int left = innerUv.x1() - uv.x1();
        int right = uv.x2() - innerUv.x2();
        int top = innerUv.y1() - uv.y1();
        int bottom = uv.y2() - innerUv.y2();
        return new Padding(left, right, top, bottom);
    }

    public static void drawContainer(GuiGraphics guiGraphics, Rect bounds) {
        DrawUtils.drawNineSliceRect(BaseTextureUv.RL, guiGraphics, bounds, BaseTextureUv.CONTAINER_UV, BaseTextureUv.CONTAINER_INNER_UV);
    }

    public static void drawScrollingString(GuiGraphics guiGraphics, Font font, Component text, Rect bounds, int color) {
        DrawUtils.drawScrollingString(guiGraphics, font, text, bounds, color, false);
    }

    public static void drawScrollingString(GuiGraphics guiGraphics, Font font, Component text, Rect bounds, int color, boolean centered) {
        int textWidth = font.m_92852_((FormattedText)text);
        int textPosY = (bounds.y1() + bounds.y2() - 9) / 2 + 1;
        int availableWidth = bounds.x2() - bounds.x1();
        if (textWidth > availableWidth) {
            int overflowWidth = textWidth - availableWidth;
            double currentTime = (double)Util.m_137550_() / 1000.0;
            double scrollSpeed = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTime / scrollSpeed)) / 2.0 + 0.5;
            double scrollOffset = Mth.m_14139_((double)scrollFactor, (double)0.0, (double)overflowWidth);
            DrawUtils.enableAdjustedScissor(guiGraphics, bounds.x1(), bounds.y1(), bounds.x2() + 1, bounds.y2());
            guiGraphics.m_280430_(font, text, bounds.x1() - (int)scrollOffset, textPosY, color);
            guiGraphics.m_280618_();
        } else if (centered) {
            guiGraphics.m_280430_(font, text, bounds.x1() + bounds.w() / 2 - font.m_92852_((FormattedText)text) / 2, textPosY, color);
        } else {
            guiGraphics.m_280430_(font, text, bounds.x1(), textPosY, color);
        }
    }

    public static void enableAdjustedScissor(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY) {
        Matrix4f pose = guiGraphics.m_280168_().m_85850_().m_252922_();
        float dx = pose.m30();
        float dy = pose.m31();
        guiGraphics.m_280588_((int)((float)minX + dx), (int)((float)minY + dy), (int)((float)maxX + dx), (int)((float)maxY + dy));
    }

    private record Padding(int left, int right, int top, int bottom) {
    }
}

