/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.musiclist;

import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.common.TwoStateImageButton;
import io.github.maki99999.biomebeats.gui.common.TypedUiContainer;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.musiclist.MusicList;
import io.github.maki99999.biomebeats.gui.musiclist.MusicListEntry;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import io.github.maki99999.biomebeats.music.MusicGroup;
import io.github.maki99999.biomebeats.music.MusicTrack;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

class MusicListEntryGroup
extends TypedUiContainer<MusicListEntry> {
    static final int CHILDREN_HEIGHT = 16;
    private static final int GROUP_HEADER_HEIGHT = 16;
    final MusicList musicList;
    private final MusicGroup musicGroup;

    public MusicListEntryGroup(MusicList musicList, int x, int y, int w, Component message, MusicGroup musicGroup, boolean isCollapsed) {
        super(message, new Rect(x, y, w, 0));
        this.musicList = musicList;
        this.musicGroup = musicGroup;
        TwoStateImageButton collapseButton = this.addChild(new TwoStateImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), (Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), w - 24, 1, new ImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), null, w - 24, 1, BaseTextureUv.ACCORDION_OPEN_UV, null), new ImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), null, w - 24, 1, BaseTextureUv.ACCORDION_CLOSE_UV, null), (btn, newValue) -> musicList.onGroupToggle.onGroupToggle(musicGroup.getName(), newValue), false));
        collapseButton.setState(isCollapsed);
        for (MusicTrack musicTrack : musicGroup.getMusicTracks()) {
            this.addTypedChild(new MusicListEntry(this, musicTrack, new Rect(1, 0, w - 2, 16)));
        }
        this.UpdateHeight();
    }

    public void UpdateHeight() {
        int childY = 20;
        for (MusicListEntry group : this.getTypedChildren()) {
            group.setY(childY);
            childY += group.getHeight() + 4;
        }
        this.setHeight(this.getTypedChildren().stream().mapToInt(UiElement::getHeight).sum() + (this.getTypedChildren().size() + 1) * 4 + 16);
        this.musicList.updateY();
    }

    @Override
    protected void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237113_((String)this.musicGroup.getName()), new Rect(this.getX() + 16, this.getY() + 4, this.getWidth() - 48, 8), BiomeBeatsColor.WHITE.getHex());
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.getTypedChildren().forEach(entry -> entry.setWidth(width - 2));
    }

    public void setCheckedMusicTracks(Collection<? extends MusicTrack> musicTracks) {
        this.getTypedChildren().forEach(child -> child.setCheckedState(musicTracks.contains(child.getMusicTrack())));
    }
}

