/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.musiclist;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.event.MusicTrackUpdateEvent;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.common.EditBoxWrapper;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.common.LayeredImageButton;
import io.github.maki99999.biomebeats.gui.common.TwoStateImageButton;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.musiclist.MusicListEntryGroup;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.PreviewListener;
import io.github.maki99999.biomebeats.util.EventBus;
import java.util.Iterator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

class MusicListEntry
extends UiElement
implements PreviewListener {
    private final MusicListEntryGroup musicListEntryGroup;
    private final MusicTrack musicTrack;
    private final TwoStateImageButton previewButton;
    private final ImageButton editButton;
    private final TwoStateImageButton checkbox;
    private final EditBoxWrapper volumeModifierEditBox;
    private final EditBoxWrapper customNameEditBox;
    private boolean editing = false;
    private Component displayName;

    public MusicListEntry(MusicListEntryGroup musicListEntryGroup, MusicTrack musicTrack, Rect bounds) {
        super((Component)Component.m_237113_((String)musicTrack.getName()), bounds);
        this.displayName = Component.m_237113_((String)musicTrack.getDisplayName());
        this.musicListEntryGroup = musicListEntryGroup;
        this.musicTrack = musicTrack;
        this.customNameEditBox = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.custom_name"), new Rect(0, 32, this.getWidth(), 16)));
        this.customNameEditBox.setHint((Component)Component.m_237113_((String)musicTrack.getName()));
        this.customNameEditBox.setResponder(this::onCustomNameChange);
        this.customNameEditBox.setVisible(false);
        if (musicTrack.getCustomName() != null) {
            this.customNameEditBox.setValue(musicTrack.getCustomName());
        }
        this.volumeModifierEditBox = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.volume_multiplier"), new Rect(this.getWidth() - 60, 48, 60, 16)));
        this.volumeModifierEditBox.setHint((Component)Component.m_237113_((String)"0"));
        this.volumeModifierEditBox.setResponder(this::onVolumeModifierChange);
        this.volumeModifierEditBox.setFilter(s -> s.matches("^\\d{0,2}\\.?\\d{0,4}$"));
        this.volumeModifierEditBox.setVisible(false);
        this.volumeModifierEditBox.setValue("" + musicTrack.getVolumeMultiplier());
        this.checkbox = this.addChild(new TwoStateImageButton((Component)Component.m_237113_((String)"Checkbox"), null, 0, 0, new LayeredImageButton((Component)Component.m_237113_((String)"Checkbox"), null, 0, 0, BaseTextureUv.CHECKBOX_CHECKED_UV, null), new LayeredImageButton((Component)Component.m_237113_((String)"Checkbox"), null, 0, 0, BaseTextureUv.BUTTON_BASE_INVERTED_UV, null), (c, newValue) -> musicListEntryGroup.musicList.onMusicTrackToggle.onMusicTrackToggle(musicTrack, newValue), false));
        this.previewButton = this.addChild(new TwoStateImageButton((Component)Component.m_237113_((String)"Play / Stop"), null, this.getWidth() - BaseTextureUv.PLAY_UV.w(), 0, new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.stop"), (Component)Component.m_237115_((String)"menu.biomebeats.stop"), this.getWidth() - BaseTextureUv.PLAY_UV.w(), 0, BaseTextureUv.STOP_UV, null), new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.play"), (Component)Component.m_237115_((String)"menu.biomebeats.play"), this.getWidth() - BaseTextureUv.PLAY_UV.w(), 0, BaseTextureUv.PLAY_UV, null), (btn, newValue) -> {
            if (newValue) {
                Constants.MUSIC_MANAGER.playPreviewTrack(musicTrack);
            } else {
                Constants.MUSIC_MANAGER.stopPreviewTrack();
            }
        }, false));
        this.editButton = this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.edit"), (Component)Component.m_237115_((String)"menu.biomebeats.edit"), this.getWidth() - this.previewButton.getWidth() - BaseTextureUv.EDIT_UV.w(), 0, BaseTextureUv.EDIT_UV, btn -> this.onEdit()));
        Constants.MUSIC_MANAGER.addPreviewListener(this);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        this.volumeModifierEditBox.setVisible(editing);
        this.customNameEditBox.setVisible(editing);
        this.setHeight(16 * (editing ? 4 : 1));
    }

    private void onVolumeModifierChange(String s) {
        double volumeMultiplier;
        try {
            volumeMultiplier = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            volumeMultiplier = 1.0;
        }
        if (volumeMultiplier >= 4.1) {
            this.volumeModifierEditBox.setValue("4.0");
            return;
        }
        this.musicTrack.setVolumeMultiplier(volumeMultiplier);
        EventBus.publish(new MusicTrackUpdateEvent(this.musicTrack));
    }

    private void onCustomNameChange(String newName) {
        this.musicTrack.setCustomName(newName);
        this.displayName = Component.m_237113_((String)this.musicTrack.getDisplayName());
    }

    private void onEdit() {
        Iterator iterator = this.musicListEntryGroup.getTypedChildren().iterator();
        while (iterator.hasNext()) {
            MusicListEntry sibling;
            sibling.setEditing((sibling = (MusicListEntry)iterator.next()) == this && !this.isEditing());
        }
        this.musicListEntryGroup.UpdateHeight();
    }

    @Override
    public void onClose() {
        Constants.MUSIC_MANAGER.removePreviewListener(this);
    }

    @Override
    protected void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + 16, BiomeBeatsColor.LIGHT_GREY.getHex());
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, this.displayName, this.getTextRect(), BiomeBeatsColor.WHITE.getHex());
        if (this.isEditing()) {
            this.renderAddon(guiGraphics);
        }
    }

    @NotNull
    private Rect getTextRect() {
        return new Rect(this.getX() + 18, this.getY(), this.editButton.getX() - (this.getX() + 22), 16);
    }

    private void renderAddon(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.getX(), this.getY() + 16, this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.LIGHT_GREY.getHex());
        Rect symbolBounds = new Rect(this.getX(), this.getY() + 16, this.getMinecraft().f_91062_.m_92895_("\u2514 "), 16);
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237113_((String)"\u2514"), symbolBounds, BiomeBeatsColor.WHITE.getHex());
        Rect textRect = new Rect(symbolBounds.x2() + 1, symbolBounds.y(), this.getWidth(), 16);
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.custom_name"), textRect, BiomeBeatsColor.WHITE.getHex());
        symbolBounds = new Rect(symbolBounds.x(), symbolBounds.y2() + 16, symbolBounds.w(), symbolBounds.h());
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237113_((String)"\u2514"), symbolBounds, BiomeBeatsColor.WHITE.getHex());
        textRect = Rect.fromCoordinates(symbolBounds.x2() + 1, symbolBounds.y(), this.volumeModifierEditBox.getX() - 2, symbolBounds.y() + 16);
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.volume_multiplier"), textRect, BiomeBeatsColor.WHITE.getHex());
    }

    public MusicTrack getMusicTrack() {
        return this.musicTrack;
    }

    public void setCheckedState(boolean newValue) {
        this.checkbox.setState(newValue);
    }

    @Override
    public void onPreviewChanged(MusicTrack previewTrack) {
        this.previewButton.setState(previewTrack != null && previewTrack.equals(this.musicTrack));
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        super.renderTooltips(guiGraphics, mousePos, absolutePos);
        if (this.getTextRect().contains(mousePos)) {
            guiGraphics.m_280557_(this.getMinecraft().f_91062_, (Component)Component.m_237113_((String)this.musicTrack.getPathName()), absolutePos.x(), absolutePos.y());
        }
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.previewButton.setX(this.getWidth() - BaseTextureUv.PLAY_UV.w());
        this.editButton.setX(this.getWidth() - this.previewButton.getWidth() - BaseTextureUv.EDIT_UV.w());
        this.customNameEditBox.setWidth(this.getWidth());
        this.volumeModifierEditBox.setX(this.getWidth() - 60);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }
}

