/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.musiclist;

import io.github.maki99999.biomebeats.gui.common.ScrollContainer;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.musiclist.MusicListEntryGroup;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import io.github.maki99999.biomebeats.music.MusicGroup;
import io.github.maki99999.biomebeats.music.MusicTrack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class MusicList
extends ScrollContainer {
    static final int CHILDREN_SPACING = 4;
    private final List<MusicListEntryGroup> entryGroups = new ArrayList<MusicListEntryGroup>();
    final OnMusicTrackToggle onMusicTrackToggle;
    final OnGroupToggle onGroupToggle;
    private final List<MusicGroup> sortedMusicGroups;

    public MusicList(Rect bounds, Component message, Collection<MusicGroup> musicGroups, OnMusicTrackToggle onMusicTrackToggle, OnGroupToggle onGroupToggle) {
        super(message, bounds);
        this.onMusicTrackToggle = onMusicTrackToggle;
        this.sortedMusicGroups = this.sortMusicGroups(musicGroups);
        this.onGroupToggle = onGroupToggle;
        this.sortAndFilterMusicTracks("", List.of(), List.of());
        this.setVisible(false);
    }

    @Override
    protected int getContentHeight() {
        int height = -2;
        for (MusicListEntryGroup entryGroup : this.entryGroups) {
            height += entryGroup.getHeight() + 5;
        }
        return height;
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
    }

    @Override
    protected void renderContent(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        if (this.isScrollbarVisible()) {
            guiGraphics.m_280509_(this.getX() + this.getWidth(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
        }
        int height = 3;
        for (int i = 0; i < this.entryGroups.size(); ++i) {
            MusicListEntryGroup entryGroup = this.entryGroups.get(i);
            entryGroup.renderAll(guiGraphics, mousePos, partialTicks);
            height += entryGroup.getHeight();
            if (i == this.entryGroups.size() - 1) continue;
            guiGraphics.m_280509_(0, height, this.getWidth(), height + 1, BiomeBeatsColor.BLACK.getHex());
            height += 5;
        }
    }

    public void setCheckedMusicTracks(Collection<? extends MusicTrack> musicTracks) {
        for (MusicListEntryGroup child : this.entryGroups) {
            child.setCheckedMusicTracks(musicTracks);
        }
    }

    private List<MusicGroup> sortMusicGroups(Collection<MusicGroup> musicGroups) {
        return musicGroups.stream().sorted((m1, m2) -> {
            if (m1.getName().contains("Custom")) {
                return -1;
            }
            if (m2.getName().contains("Custom")) {
                return 1;
            }
            if (m1.getName().contains("Minecraft") != m2.getName().contains("Minecraft")) {
                if (m1.getName().contains("Minecraft")) {
                    return -1;
                }
                if (m2.getName().contains("Minecraft")) {
                    return 1;
                }
            }
            return m1.getName().compareTo(m2.getName());
        }).toList();
    }

    public void sortAndFilterMusicTracks(String filter, Collection<? extends MusicTrack> checkedMusicTracks, Collection<String> collapsedMusicGroups) {
        ArrayList<MusicGroup> sortedMusic = new ArrayList<MusicGroup>();
        for (MusicGroup musicGroup : this.sortedMusicGroups) {
            sortedMusic.add(new MusicGroup(musicGroup.getName(), musicGroup.getMusicTracks().stream().filter(m -> !collapsedMusicGroups.contains(musicGroup.getName()) && (m.getCustomName() != null && m.getCustomName().toLowerCase().contains(filter) || m.getName().toLowerCase().contains(filter))).sorted(Comparator.comparing(t -> !checkedMusicTracks.contains(t)).thenComparing(MusicTrack::getDisplayName)).toList()));
        }
        this.updateVisibleMusicTracks(sortedMusic, collapsedMusicGroups);
        this.setCheckedMusicTracks(checkedMusicTracks);
        this.mouseScrolled(new PointD(0.0, 0.0), 0.0, 0.0);
    }

    private void updateVisibleMusicTracks(Collection<MusicGroup> musicGroups, Collection<String> collapsedMusicGroups) {
        this.entryGroups.clear();
        for (MusicGroup musicGroup : musicGroups) {
            this.entryGroups.add(new MusicListEntryGroup(this, 0, 0, this.getWidth(), (Component)Component.m_237113_((String)musicGroup.getName()), musicGroup, collapsedMusicGroups.contains(musicGroup.getName())));
        }
        int childrenWidth = this.isScrollbarVisible() ? this.getWidth() - 6 : this.getWidth();
        this.entryGroups.forEach(entry -> entry.setWidth(childrenWidth));
        this.updateY();
    }

    void updateY() {
        int height = 3;
        for (int i = 0; i < this.entryGroups.size(); ++i) {
            MusicListEntryGroup entryGroup = this.entryGroups.get(i);
            entryGroup.setY(height);
            height += entryGroup.getHeight();
            if (i == this.entryGroups.size() - 1) continue;
            height += 5;
        }
    }

    @Override
    public boolean mouseClickedAll(PointD mousePos, int button) {
        for (UiElement uiElement : this.getChildren()) {
            if (!uiElement.isMouseOver(mousePos.translate(-this.getX(), -this.getY()).toIntPoint()) || !uiElement.mouseClickedAll(mousePos.translate(-this.getX(), -this.getY()), button)) continue;
            this.setFocusedElement(uiElement);
            this.setDraggingElement(uiElement);
            return true;
        }
        for (MusicListEntryGroup musicListEntryGroup : this.entryGroups) {
            if (!musicListEntryGroup.isMouseOver(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()).toIntPoint()) || !musicListEntryGroup.mouseClickedAll(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()), button)) continue;
            this.setFocusedElement(musicListEntryGroup);
            this.setDraggingElement(musicListEntryGroup);
            return true;
        }
        if (this.isMouseOver(mousePos) && this.mouseClicked(mousePos, button)) {
            this.setFocusedElement(this);
            this.setDraggingElement(this);
            return true;
        }
        this.setFocusedElement(null);
        this.setDraggingElement(null);
        return false;
    }

    @Override
    public void renderTooltipsInContent(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        for (MusicListEntryGroup child : this.entryGroups) {
            child.renderTooltips(guiGraphics, mousePos, absolutePos);
        }
    }

    public static interface OnMusicTrackToggle {
        public void onMusicTrackToggle(MusicTrack var1, boolean var2);
    }

    public static interface OnGroupToggle {
        public void onGroupToggle(String var1, boolean var2);
    }
}

