/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.conditionlist;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.ConditionViewModel;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.common.LayeredImageButton;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.conditionlist.ConditionList;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

class ConditionListEntry
extends UiElement {
    private final Minecraft minecraft;
    private final ConditionViewModel vm;
    private final ImageButton editButton;
    private final Component tooltipText;

    public ConditionListEntry(ConditionList conditionList, Minecraft minecraft, Rect bounds, Condition condition) {
        super((Component)Component.m_237113_((String)condition.getName()), bounds);
        this.minecraft = minecraft;
        this.vm = new ConditionViewModel(condition, !Constants.CONDITION_MUSIC_MANAGER.getMusicTracksForCondition(condition.getId()).isEmpty());
        if (condition instanceof CombinedCondition) {
            CombinedCondition combinedCondition = (CombinedCondition)condition;
            this.editButton = this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.edit"), (Component)Component.m_237115_((String)"menu.biomebeats.edit"), this.getWidth() - BaseTextureUv.EDIT_UV.w(), 0, BaseTextureUv.EDIT_UV, click -> conditionList.onEditPress.onEditPress(combinedCondition)));
            this.tooltipText = Component.m_237113_((String)combinedCondition.getDescription());
        } else {
            this.editButton = null;
            this.tooltipText = null;
        }
    }

    public Condition getCondition() {
        return this.vm.getCondition();
    }

    @Override
    protected void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        if (this.vm.isSelected()) {
            guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.WHITE.getHex());
            guiGraphics.m_280509_(this.getX() + 1, this.getY() + 1, this.getX() - 1 + this.getWidth(), this.getY() - 1 + this.getHeight(), BiomeBeatsColor.LIGHT_GREY.getHex());
        } else {
            guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.LIGHT_GREY.getHex());
        }
        this.drawIndicator(guiGraphics);
        DrawUtils.drawScrollingString(guiGraphics, this.minecraft.f_91062_, this.getName(), this.getTextRect(), BiomeBeatsColor.WHITE.getHex());
    }

    @NotNull
    private Rect getTextRect() {
        return new Rect(this.getX() + 4, this.getY(), this.getWidth() - (this.editButton == null ? 8 : 8 + BaseTextureUv.EDIT_UV.w()), this.getHeight());
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        super.renderTooltips(guiGraphics, mousePos, absolutePos);
        if (this.tooltipText != null && this.getTextRect().contains(mousePos)) {
            guiGraphics.m_280557_(this.minecraft.f_91062_, this.tooltipText, absolutePos.x(), absolutePos.y());
        }
    }

    private void drawIndicator(@NotNull GuiGraphics guiGraphics) {
        int offset = this.vm.isSelected() ? 1 : 0;
        guiGraphics.m_280509_(this.getX() + offset, this.getY() + offset, this.getX() + 2, this.getY() + this.getHeight() - offset, this.vm.getIndicatorColor());
    }

    public void setSelected(boolean selected) {
        this.vm.setSelected(selected);
    }
}

