/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.conditionlist;

import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.gui.common.ScrollContainer;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.conditionlist.ConditionListEntry;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionList
extends ScrollContainer {
    private static final int CHILDREN_HEIGHT = 16;
    private static final int CHILDREN_SPACING = 4;
    private final OnSelected onSelected;
    final OnEditPress onEditPress;
    private final Minecraft minecraft;
    private ArrayList<ConditionListEntry> entries = new ArrayList();
    @Nullable
    private ConditionListEntry selectedChild = null;

    public ConditionList(Minecraft minecraft, Rect bounds, Component message, OnSelected onSelected, OnEditPress onEditPress) {
        super(message, bounds);
        this.onSelected = onSelected;
        this.onEditPress = onEditPress;
        this.minecraft = minecraft;
    }

    @Override
    protected int getContentHeight() {
        return this.contentHeight(this.entries.size());
    }

    private int contentHeight(int childrenCount) {
        return Math.max(childrenCount * 20, 0);
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
    }

    @Override
    protected void renderContent(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        if (this.isScrollbarVisible()) {
            guiGraphics.m_280509_(this.getX() + this.getWidth(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
        }
        for (ConditionListEntry entry : this.entries) {
            entry.setSelected(entry == this.selectedChild);
            entry.renderAll(guiGraphics, mousePos, partialTicks);
        }
    }

    public void setConditions(Collection<? extends Condition> conditions, Condition currentCondition) {
        int childrenWidth = this.contentHeight(conditions.size()) > this.getHeight() ? this.getWidth() - 6 - 2 : this.getWidth() - 2;
        this.entries = new ArrayList();
        for (Condition condition : conditions) {
            ConditionListEntry entry = new ConditionListEntry(this, this.minecraft, new Rect(1, 2 + this.entries.size() * 20, childrenWidth, 16), condition);
            this.entries.add(entry);
        }
        this.selectedChild = currentCondition == null ? null : (ConditionListEntry)this.entries.stream().filter(c -> c.getCondition() == currentCondition).findAny().orElse(null);
        this.setScrollAmount(0.0);
    }

    @Override
    public boolean mouseClickedAll(PointD mousePos, int button) {
        for (UiElement uiElement : this.getChildren()) {
            if (!uiElement.isMouseOver(mousePos.translate(-this.getX(), -this.getY()).toIntPoint()) || !uiElement.mouseClickedAll(mousePos.translate(-this.getX(), -this.getY()), button)) continue;
            this.setFocusedElement(uiElement);
            this.setDraggingElement(uiElement);
            return true;
        }
        for (ConditionListEntry conditionListEntry : this.entries) {
            if (!conditionListEntry.isMouseOver(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()).toIntPoint()) || !conditionListEntry.mouseClickedAll(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()), button)) continue;
            this.selectedChild = conditionListEntry;
            this.onSelected.onSelected(conditionListEntry.getCondition());
            this.setFocusedElement(conditionListEntry);
            this.setDraggingElement(conditionListEntry);
            return true;
        }
        if (this.isMouseOver(mousePos) && this.mouseClicked(mousePos, button)) {
            this.setFocusedElement(this);
            this.setDraggingElement(this);
            return true;
        }
        this.setFocusedElement(null);
        this.setDraggingElement(null);
        return false;
    }

    @Override
    public void renderTooltipsInContent(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        for (ConditionListEntry child : this.entries) {
            child.renderTooltips(guiGraphics, mousePos, absolutePos);
        }
    }

    public static interface OnSelected {
        public void onSelected(Condition var1);
    }

    public static interface OnEditPress {
        public void onEditPress(CombinedCondition var1);
    }
}

