/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.condcheckboxlist;

import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.common.TwoStateImageButton;
import io.github.maki99999.biomebeats.gui.common.TypedUiContainer;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.condcheckboxlist.ConditionCheckboxList;
import io.github.maki99999.biomebeats.gui.condcheckboxlist.ConditionCheckboxListEntry;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

class ConditionCheckboxListEntryGroup
extends TypedUiContainer<ConditionCheckboxListEntry> {
    private static final int CHILDREN_HEIGHT = 16;
    private static final int GROUP_HEADER_HEIGHT = 16;
    private static final int CHILDREN_SPACING = 4;
    final ConditionCheckboxList conditionCheckboxList;

    public ConditionCheckboxListEntryGroup(ConditionCheckboxList conditionCheckboxList, int x, int y, int w, Component message, Collection<Condition> conditions, Component typeName, boolean isCollapsed) {
        super(message, new Rect(x, y, w, 0));
        this.conditionCheckboxList = conditionCheckboxList;
        TwoStateImageButton collapseButton = this.addChild(new TwoStateImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), (Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), w - 24, 1, new ImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), null, w - 24, 1, BaseTextureUv.ACCORDION_OPEN_UV, null), new ImageButton((Component)Component.m_237115_((String)"menu.biomebeats.expand_collapse"), null, w - 24, 1, BaseTextureUv.ACCORDION_CLOSE_UV, null), (btn, newValue) -> conditionCheckboxList.onGroupToggle.onGroupToggle(typeName, newValue), false));
        collapseButton.setState(isCollapsed);
        for (Condition condition : conditions) {
            this.addTypedChild(new ConditionCheckboxListEntry(this, condition, new Rect(1, 0, w - 2, 16)));
        }
        this.UpdateHeight();
    }

    public void UpdateHeight() {
        int childY = 20;
        for (ConditionCheckboxListEntry group : this.getTypedChildren()) {
            group.setY(childY);
            childY += group.getHeight() + 4;
        }
        this.setHeight(this.getTypedChildren().stream().mapToInt(UiElement::getHeight).sum() + (this.getTypedChildren().size() + 1) * 4 + 16);
        this.conditionCheckboxList.updateY();
    }

    @Override
    protected void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, this.getName(), new Rect(this.getX() + 16, this.getY() + 4, this.getWidth() - 48, 8), BiomeBeatsColor.WHITE.getHex());
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.getTypedChildren().forEach(entry -> entry.setWidth(width - 2));
    }

    public void setCheckedConditions(Collection<? extends Condition> conditions) {
        this.getTypedChildren().forEach(child -> child.setCheckedState(conditions.contains(child.getCondition())));
    }
}

