/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.condcheckboxlist;

import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.gui.common.ScrollContainer;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.condcheckboxlist.ConditionCheckboxListEntryGroup;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConditionCheckboxList
extends ScrollContainer {
    private static final List<Component> GROUP_ORDER = new ArrayList<Component>();
    private static final Comparator<Component> GROUP_ORDER_COMPARATOR;
    private final List<ConditionCheckboxListEntryGroup> entryGroups = new ArrayList<ConditionCheckboxListEntryGroup>();
    final OnConditionToggle onConditionToggle;
    final OnGroupToggle onGroupToggle;
    private final Collection<Condition> conditions;

    public ConditionCheckboxList(Rect bounds, Component message, Collection<Condition> conditions, OnConditionToggle onConditionToggle, OnGroupToggle onGroupToggle) {
        super(message, bounds);
        this.onConditionToggle = onConditionToggle;
        this.conditions = conditions;
        this.onGroupToggle = onGroupToggle;
        this.sortAndFilterConditions("", List.of(), List.of());
    }

    @Override
    protected int getContentHeight() {
        int height = -2;
        for (ConditionCheckboxListEntryGroup entryGroup : this.entryGroups) {
            height += entryGroup.getHeight() + 5;
        }
        return height;
    }

    @Override
    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
        if (this.isScrollbarVisible()) {
            guiGraphics.m_280509_(this.getX() + this.getWidth(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BiomeBeatsColor.DARK_GREY.getHex());
        }
    }

    @Override
    protected void renderContent(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTicks) {
        int height = 3;
        for (int i = 0; i < this.entryGroups.size(); ++i) {
            ConditionCheckboxListEntryGroup entryGroup = this.entryGroups.get(i);
            entryGroup.renderAll(guiGraphics, mousePos, partialTicks);
            height += entryGroup.getHeight();
            if (i == this.entryGroups.size() - 1) continue;
            guiGraphics.m_280509_(0, height, this.getWidth(), height + 1, BiomeBeatsColor.BLACK.getHex());
            height += 5;
        }
    }

    void updateY() {
        int height = 3;
        for (int i = 0; i < this.entryGroups.size(); ++i) {
            ConditionCheckboxListEntryGroup entryGroup = this.entryGroups.get(i);
            entryGroup.setY(height);
            height += entryGroup.getHeight();
            if (i == this.entryGroups.size() - 1) continue;
            height += 5;
        }
    }

    @Override
    public boolean mouseClickedAll(PointD mousePos, int button) {
        for (UiElement uiElement : this.getChildren()) {
            if (!uiElement.isMouseOver(mousePos.translate(-this.getX(), -this.getY()).toIntPoint()) || !uiElement.mouseClickedAll(mousePos.translate(-this.getX(), -this.getY()), button)) continue;
            this.setFocusedElement(uiElement);
            this.setDraggingElement(uiElement);
            return true;
        }
        for (ConditionCheckboxListEntryGroup conditionCheckboxListEntryGroup : this.entryGroups) {
            if (!conditionCheckboxListEntryGroup.isMouseOver(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()).toIntPoint()) || !conditionCheckboxListEntryGroup.mouseClickedAll(mousePos.translate(-this.getX(), (double)(-this.getY()) + this.getScrollAmount()), button)) continue;
            this.setFocusedElement(conditionCheckboxListEntryGroup);
            this.setDraggingElement(conditionCheckboxListEntryGroup);
            return true;
        }
        if (this.isMouseOver(mousePos) && this.mouseClicked(mousePos, button)) {
            this.setFocusedElement(this);
            this.setDraggingElement(this);
            return true;
        }
        this.setFocusedElement(null);
        this.setDraggingElement(null);
        return false;
    }

    @Override
    public void renderTooltipsInContent(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        for (ConditionCheckboxListEntryGroup child : this.entryGroups) {
            child.renderTooltips(guiGraphics, mousePos, absolutePos);
        }
    }

    public void setCheckedConditions(Collection<Condition> conditions) {
        for (ConditionCheckboxListEntryGroup child : this.entryGroups) {
            child.setCheckedConditions(conditions);
        }
    }

    public void sortAndFilterConditions(String filter, Collection<Condition> checkedConditions, Collection<Component> collapsedGroups) {
        HashSet typeNames = new HashSet();
        Map<Component, List<Condition>> conditionsByType = this.conditions.stream().filter(c -> !(c instanceof CombinedCondition)).peek(c -> typeNames.add(c.getType().getComponent())).filter(c -> !collapsedGroups.contains(c.getType().getComponent()) && c.getName().toLowerCase().contains(filter)).sorted(Comparator.comparing(Condition::getName)).collect(Collectors.groupingBy(x -> x.getType().getComponent()));
        this.entryGroups.clear();
        for (Component conditionType : typeNames.stream().sorted(GROUP_ORDER_COMPARATOR).toList()) {
            if (conditionsByType.containsKey(conditionType)) {
                this.entryGroups.add(new ConditionCheckboxListEntryGroup(this, 0, 0, this.getWidth(), conditionType, (Collection<Condition>)conditionsByType.get(conditionType), conditionType, collapsedGroups.contains(conditionType)));
                continue;
            }
            this.entryGroups.add(new ConditionCheckboxListEntryGroup(this, 0, 0, this.getWidth(), conditionType, List.of(), conditionType, collapsedGroups.contains(conditionType)));
        }
        int childrenWidth = this.isScrollbarVisible() ? this.getWidth() - 6 : this.getWidth();
        for (ConditionCheckboxListEntryGroup entry : this.entryGroups) {
            entry.setWidth(childrenWidth);
        }
        this.updateY();
        this.setCheckedConditions(checkedConditions);
        this.mouseScrolled(new PointD(0.0, 0.0), 0.0, 0.0);
    }

    static {
        GROUP_ORDER.add((Component)Component.m_237115_((String)"menu.biomebeats.by_biome"));
        GROUP_ORDER.add((Component)Component.m_237115_((String)"menu.biomebeats.by_tag"));
        GROUP_ORDER.add((Component)Component.m_237115_((String)"menu.biomebeats.by_time"));
        GROUP_ORDER.add((Component)Component.m_237115_((String)"menu.biomebeats.by_other"));
        GROUP_ORDER.add((Component)Component.m_237115_((String)"menu.biomebeats.combined"));
        GROUP_ORDER_COMPARATOR = Comparator.comparingInt(c -> {
            int index = GROUP_ORDER.indexOf(c);
            return index == -1 ? Integer.MAX_VALUE : index;
        });
    }

    public static interface OnConditionToggle {
        public void onConditionToggle(Condition var1, boolean var2);
    }

    public static interface OnGroupToggle {
        public void onGroupToggle(Component var1, boolean var2);
    }
}

