/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.common;

import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class UiElement {
    private final Component name;
    private final Component tooltip;
    private final List<UiElement> children = new ArrayList<UiElement>();
    private final Minecraft minecraft;
    private boolean visible = true;
    private UiElement focusedElement = null;
    private UiElement draggingElement = null;
    private int x;
    private int y;
    private int width;
    private int height;

    protected UiElement(Component name, Component tooltip, Rect bounds) {
        this.name = name;
        this.tooltip = tooltip;
        this.minecraft = Minecraft.m_91087_();
        if (bounds != null) {
            this.x = bounds.x();
            this.y = bounds.y();
            this.width = bounds.w();
            this.height = bounds.h();
        }
    }

    protected UiElement(Component name) {
        this(name, null, null);
    }

    public UiElement(Component name, Component tooltip) {
        this(name, tooltip, null);
    }

    public UiElement(Component name, Rect bounds) {
        this(name, null, bounds);
    }

    protected final void initAll() {
        this.init();
        for (UiElement child : this.children) {
            child.initAll();
        }
    }

    protected void init() {
    }

    protected final void onCloseAll() {
        for (UiElement child : this.children) {
            child.onCloseAll();
        }
        this.onClose();
    }

    protected void onClose() {
    }

    public final void renderAll(GuiGraphics guiGraphics, Point mousePos, float deltaTime) {
        if (!this.visible) {
            return;
        }
        this.render(guiGraphics, mousePos, deltaTime);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.x, (float)this.y, 0.0f);
        for (UiElement child : this.children) {
            child.renderAll(guiGraphics, mousePos.translate(-this.x, -this.y), deltaTime);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected abstract void render(GuiGraphics var1, Point var2, float var3);

    public void renderTooltips(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        if (!this.visible) {
            return;
        }
        if (this.tooltip != null && this.isMouseOver(mousePos)) {
            guiGraphics.m_280557_(this.minecraft.f_91062_, this.tooltip, absolutePos.x(), absolutePos.y());
        }
        for (UiElement child : this.children) {
            child.renderTooltips(guiGraphics, mousePos.translate(-this.x, -this.y), absolutePos);
        }
    }

    public boolean mouseClickedAll(PointD mousePos, int button) {
        for (UiElement child : this.getChildren()) {
            if (!child.isMouseOver(mousePos.translate(-this.x, -this.y).toIntPoint()) || !child.mouseClickedAll(mousePos.translate(-this.x, -this.y), button)) continue;
            this.setFocusedElement(child);
            this.setDraggingElement(child);
            return true;
        }
        if (this.isMouseOver(mousePos) && this.mouseClicked(mousePos, button)) {
            this.setFocusedElement(this);
            this.setDraggingElement(this);
            return true;
        }
        this.setFocusedElement(null);
        this.setDraggingElement(null);
        return false;
    }

    protected void setDraggingElement(UiElement draggingElement) {
        this.draggingElement = draggingElement;
    }

    protected final boolean mouseReleasedAll(PointD mousePos, int button) {
        if (this.draggingElement == this) {
            this.setDraggingElement(null);
            return this.mouseReleased(mousePos, button);
        }
        if (this.draggingElement != null) {
            boolean result = this.draggingElement.mouseReleasedAll(mousePos, button);
            this.setDraggingElement(null);
            if (result) {
                return true;
            }
        }
        for (UiElement child : this.children) {
            if (!child.isMouseOver(mousePos) || !child.mouseReleasedAll(mousePos, button)) continue;
            return true;
        }
        return this.mouseReleased(mousePos, button);
    }

    protected final boolean mouseDraggedAll(PointD mousePos, int button, double deltaX, double deltaY) {
        if (this.draggingElement != null) {
            return this.draggingElement == this ? this.mouseDragged(mousePos, button, deltaX, deltaY) : this.draggingElement.mouseDraggedAll(mousePos, button, deltaX, deltaY);
        }
        return false;
    }

    protected final boolean mouseScrolledAll(PointD mousePos, double scrollX, double scrollY) {
        for (UiElement child : this.children) {
            if (!child.isMouseOver(mousePos) || !child.mouseScrolledAll(mousePos, scrollX, scrollY)) continue;
            return true;
        }
        return this.mouseScrolled(mousePos, scrollX, scrollY);
    }

    protected final boolean keyPressedAll(int keyCode, int scanCode, int modifiers) {
        if (this.focusedElement == null) {
            return false;
        }
        return this.focusedElement == this ? this.keyPressed(keyCode, scanCode, modifiers) : this.focusedElement.keyPressedAll(keyCode, scanCode, modifiers);
    }

    protected final boolean keyReleasedAll(int keyCode, int scanCode, int modifiers) {
        if (this.focusedElement == null) {
            return false;
        }
        return this.focusedElement == this ? this.keyReleased(keyCode, scanCode, modifiers) : this.focusedElement.keyReleasedAll(keyCode, scanCode, modifiers);
    }

    protected final boolean charTypedAll(char codePoint, int modifiers) {
        if (this.focusedElement == null) {
            return false;
        }
        return this.focusedElement == this ? this.charTyped(codePoint, modifiers) : this.focusedElement.charTypedAll(codePoint, modifiers);
    }

    protected boolean mouseClicked(PointD mousePos, int button) {
        return this.getBounds().contains(mousePos);
    }

    protected boolean mouseReleased(PointD mousePos, int button) {
        return this.getBounds().contains(mousePos);
    }

    protected boolean mouseDragged(PointD mousePos, int button, double deltaX, double deltaY) {
        return this.getBounds().contains(mousePos);
    }

    protected boolean mouseScrolled(PointD mousePos, double scrollX, double scrollY) {
        return this.getBounds().contains(mousePos);
    }

    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    protected final boolean isMouseOver(PointD mousePosition) {
        return this.getBounds().containsD(mousePosition.x(), mousePosition.y());
    }

    public final boolean isMouseOver(Point mousePosition) {
        return this.getBounds().contains(mousePosition.x(), mousePosition.y());
    }

    protected final void setFocusedElement(UiElement element) {
        if (this.focusedElement == element) {
            return;
        }
        if (this.focusedElement != null) {
            this.focusedElement.onFocusLost();
            this.focusedElement.clearFocus();
        }
        this.focusedElement = element;
        if (element != null) {
            element.onFocusGained();
        }
    }

    private void clearFocus() {
        if (this.focusedElement == null) {
            return;
        }
        if (this.focusedElement != this) {
            this.focusedElement.clearFocus();
            this.focusedElement.onFocusLost();
        }
        this.focusedElement = null;
    }

    protected final boolean isFocused() {
        return this.focusedElement == this;
    }

    protected void onFocusGained() {
    }

    protected void onFocusLost() {
    }

    protected final <T extends UiElement> T addChild(T element) {
        this.children.add(element);
        return element;
    }

    protected final void removeChild(UiElement element) {
        element.onCloseAll();
        this.children.remove(element);
    }

    public final List<UiElement> getChildren() {
        return this.children.stream().toList();
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final void tick() {
        for (UiElement child : this.children) {
            child.tick();
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    protected void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Rect getBounds() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    protected void setBounds(Rect bounds) {
        this.setX(bounds.x());
        this.setY(bounds.y());
        this.setWidth(bounds.w());
        this.setHeight(bounds.h());
    }

    protected Minecraft getMinecraft() {
        return this.minecraft;
    }

    protected Component getName() {
        return this.name;
    }

    public void clearChildren() {
        this.children.forEach(UiElement::onCloseAll);
        this.children.clear();
    }
}

