/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.common;

import io.github.maki99999.biomebeats.gui.common.Button;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TwoStateImageButton
extends ImageButton {
    private final ImageButton positiveButton;
    private final ImageButton negativeButton;
    private final OnValueChange onValueChange;
    private final boolean nameVisible;
    private boolean state = false;

    public TwoStateImageButton(Component name, Component tooltip, int x, int y, ImageButton positiveButton, ImageButton negativeButton, OnValueChange onValueChange, boolean nameVisible) {
        super(name, tooltip, x, y, positiveButton.getUv(), null);
        this.positiveButton = positiveButton;
        this.negativeButton = negativeButton;
        this.onValueChange = onValueChange;
        this.nameVisible = nameVisible;
        this.setOnPress(this::onValueChange);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float deltaTime) {
        if (this.state) {
            this.positiveButton.render(guiGraphics, mousePos, deltaTime);
        } else {
            this.negativeButton.render(guiGraphics, mousePos, deltaTime);
        }
        if (this.nameVisible) {
            DrawUtils.drawScrollingString(guiGraphics, Minecraft.m_91087_().f_91062_, this.getName(), new Rect(this.getX() + 8, this.getY(), this.getUv().w() - 12, this.getUv().h()), BiomeBeatsColor.WHITE.getHex());
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.positiveButton.setY(y);
        this.negativeButton.setY(y);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.positiveButton.setX(x);
        this.negativeButton.setX(x);
    }

    private void onValueChange(Button btn) {
        this.state = !this.state;
        this.onValueChange.onValueChange((TwoStateImageButton)btn, this.state);
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public void toggle() {
        this.state = !this.state;
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        super.renderTooltips(guiGraphics, mousePos, absolutePos);
        if (this.state) {
            this.positiveButton.renderTooltips(guiGraphics, mousePos, absolutePos);
        } else {
            this.negativeButton.renderTooltips(guiGraphics, mousePos, absolutePos);
        }
    }

    @Override
    public boolean mouseClicked(PointD mousePos, int button) {
        if (this.state ? this.positiveButton.mouseClicked(mousePos, button) : this.negativeButton.mouseClicked(mousePos, button)) {
            return true;
        }
        return super.mouseClicked(mousePos, button);
    }

    public static interface OnValueChange {
        public void onValueChange(TwoStateImageButton var1, boolean var2);
    }
}

