/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui.common;

import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.PointD;
import io.github.maki99999.biomebeats.gui.util.Rect;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class ScrollContainer
extends UiElement {
    private static final ResourceLocation SCROLLER_SPRITE = new ResourceLocation("widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = new ResourceLocation("widget/scroller_background");
    protected static final int SCROLLBAR_WIDTH = 6;
    private static final double SCROLL_RATE = 30.0;
    private double scrollAmount;
    private boolean scrolling;

    protected ScrollContainer(Component name, Rect bounds) {
        super(name, bounds);
    }

    protected abstract int getContentHeight();

    @Override
    protected final void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        this.renderBackground(guiGraphics);
        DrawUtils.enableAdjustedScissor(guiGraphics, this.getX(), this.getY() + 1, this.getX() + this.getWidth(), this.getY() - 1 + this.getHeight());
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)this.getX(), (double)this.getY() - this.scrollAmount, 0.0);
        this.renderContent(guiGraphics, mousePos.translate(-this.getX(), -this.getY() + (int)this.scrollAmount), partialTick);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280618_();
        this.renderScrollbar(guiGraphics);
    }

    protected abstract void renderBackground(GuiGraphics var1);

    protected abstract void renderContent(@NotNull GuiGraphics var1, Point var2, float var3);

    protected void renderScrollbar(GuiGraphics guiGraphics) {
        if (this.isScrollbarVisible()) {
            int i = this.getScrollerHeight();
            int j = this.getX() + this.getWidth() - 6;
            int k = this.getX() + this.getWidth();
            int l = Math.max(this.getY(), (int)this.scrollAmount * (this.getHeight() - i) / this.getMaxScrollAmount() + this.getY());
            int m = l + i;
            guiGraphics.m_280509_(j, l, k, m, -8355712);
            guiGraphics.m_280509_(j, l, k - 1, m - 1, -4144960);
        }
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, Point mousePos, Point absolutePos) {
        if (!this.isVisible()) {
            return;
        }
        super.renderTooltips(guiGraphics, mousePos, absolutePos);
        this.renderTooltipsInContent(guiGraphics, mousePos.translate(-this.getX(), -this.getY() + (int)this.scrollAmount), absolutePos);
    }

    protected abstract void renderTooltipsInContent(GuiGraphics var1, Point var2, Point var3);

    protected int scrollBarX() {
        return this.getBounds().x2() - 6;
    }

    protected int scrollBarY() {
        return Math.max(this.getY(), (int)this.scrollAmount * (this.getHeight() - this.getScrollerHeight()) / this.getMaxScrollAmount() + this.getY());
    }

    public int getMaxScrollAmount() {
        return Math.max(0, this.getContentHeight() - this.getHeight());
    }

    protected boolean isScrollbarVisible() {
        return this.getMaxScrollAmount() > 0;
    }

    private int getScrollerHeight() {
        return Mth.m_14045_((int)((int)((float)(this.getHeight() * this.getHeight()) / (float)this.getContentHeight())), (int)32, (int)(this.getHeight() - 8));
    }

    @Override
    public final boolean mouseScrolled(PointD mousePos, double scrollX, double scrollY) {
        if (!this.isVisible()) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - scrollY * 30.0);
        return true;
    }

    @Override
    public final boolean mouseDragged(PointD mousePos, int button, double deltaX, double deltaY) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.scrolling) {
            if (mousePos.y() < (double)this.getY()) {
                this.setScrollAmount(0.0);
            } else if (mousePos.y() > (double)this.getBounds().y2()) {
                this.setScrollAmount(this.getMaxScrollAmount());
            } else {
                double d0 = Math.max(1, this.getMaxScrollAmount());
                int i = this.getScrollerHeight();
                double d1 = Math.max(1.0, d0 / (double)(this.getHeight() - i));
                this.setScrollAmount(this.scrollAmount + deltaY * d1);
            }
            return true;
        }
        return false;
    }

    @Override
    protected final boolean mouseClicked(PointD mousePos, int button) {
        if (!this.isVisible()) {
            return false;
        }
        return this.updateScrolling(mousePos, button) || super.mouseClicked(mousePos, button);
    }

    @Override
    public boolean mouseReleased(PointD mousePos, int button) {
        if (!this.isVisible()) {
            return false;
        }
        this.scrolling = false;
        return true;
    }

    public void setScrollAmount(double scrollAmount) {
        if (!this.isVisible()) {
            return;
        }
        this.scrollAmount = Mth.m_14008_((double)scrollAmount, (double)0.0, (double)this.getMaxScrollAmount());
    }

    public boolean updateScrolling(PointD mousePos, int button) {
        if (!this.isVisible()) {
            return false;
        }
        this.scrolling = this.isScrollbarVisible() && button == 0 && mousePos.x() >= (double)this.scrollBarX() && mousePos.x() <= (double)(this.scrollBarX() + 6) && mousePos.y() >= (double)this.getY() && mousePos.y() < (double)this.getBounds().y2();
        return this.scrolling;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }
}

