/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.ConfigScreen;
import io.github.maki99999.biomebeats.gui.common.Button;
import io.github.maki99999.biomebeats.gui.common.EditBoxWrapper;
import io.github.maki99999.biomebeats.gui.common.TextButton;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.GridLayout;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GeneralConfigScreen
extends UiElement {
    private static final int ELEMENT_HEIGHT = 17;
    private static final int SPACING = 4;
    private final ConfigScreen configScreen;
    private Rect bounds;
    private Rect dangerBounds;
    private EditBoxWrapper fadeTimeEditBox;
    private EditBoxWrapper breakTimeEditBox;
    private GridLayout topGrid;
    private GridLayout dangerGrid;

    public GeneralConfigScreen(ConfigScreen configScreen) {
        super((Component)Component.m_237113_((String)"BiomeBeats settings config screen"));
        this.configScreen = configScreen;
    }

    @Override
    protected void init() {
        int heightUpperPart = 46;
        int heightLowerPart = 54;
        int innerHeight = heightUpperPart + heightLowerPart;
        int innerWidth = 260;
        this.bounds = new Rect((this.getWidth() - innerWidth) / 2, (this.getHeight() - innerHeight) / 2, innerWidth, innerHeight);
        Rect mainAreaBounds = new Rect(this.bounds.x(), this.bounds.y(), innerWidth, heightUpperPart);
        this.dangerBounds = new Rect(mainAreaBounds.x() + 4, mainAreaBounds.y2() + 4, innerWidth - 8, heightLowerPart - 8);
        this.topGrid = new GridLayout(mainAreaBounds, 2, 2, 4);
        this.dangerGrid = new GridLayout(this.dangerBounds, 2, 2, 4);
        this.addChild(new TextButton((Component)Component.m_237115_((String)"menu.biomebeats.reset-to-default"), (Component)Component.m_237115_((String)"menu.biomebeats.reset-to-default-tooltip"), this.dangerGrid.getCell(0, 1), this::onResetToDefault));
        this.addChild(new TextButton((Component)Component.m_237115_((String)"menu.biomebeats.clear-config"), (Component)Component.m_237115_((String)"menu.biomebeats.clear-config-tooltip"), this.dangerGrid.getCell(1, 1), this::onClearConfig));
        Rect fadeTimeEditBoxBounds = this.topGrid.getCell(0, 1);
        this.fadeTimeEditBox = this.addChild(new EditBoxWrapper((Component)Component.m_237113_((String)"1 s"), fadeTimeEditBoxBounds));
        this.fadeTimeEditBox.setHint((Component)Component.m_237113_((String)"1 s"));
        this.fadeTimeEditBox.setFilter(s -> s.matches("^\\d{0,9}$"));
        Rect breakTimeEditBoxBounds = this.topGrid.getCell(1, 1);
        this.breakTimeEditBox = this.addChild(new EditBoxWrapper((Component)Component.m_237113_((String)"0 s"), breakTimeEditBoxBounds));
        this.breakTimeEditBox.setHint((Component)Component.m_237113_((String)"0 s"));
        this.breakTimeEditBox.setFilter(s -> s.matches("^\\d{0,9}$"));
        this.loadSettings();
    }

    @Override
    public void render(GuiGraphics guiGraphics, Point mousePos, float deltaTime) {
        DrawUtils.drawContainer(guiGraphics, this.bounds);
        DrawUtils.drawTiledNineSliceRect(BaseTextureUv.RL, guiGraphics, this.dangerBounds, BaseTextureUv.DANGER_BORDER_UV, BaseTextureUv.DANGER_BORDER_INNER_UV);
        if (this.getMinecraft() != null) {
            DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.fade-time"), this.topGrid.getCell(0, 0), BiomeBeatsColor.WHITE.getHex());
            DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.break-time"), this.topGrid.getCell(1, 0), BiomeBeatsColor.WHITE.getHex());
            DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.configs"), this.dangerGrid.getCell(0, 0), BiomeBeatsColor.WHITE.getHex());
        }
    }

    private void onResetToDefault(Button button) {
        Constants.CONFIG_IO.resetConfig();
        this.loadSettings();
    }

    private void onClearConfig(Button button) {
        Constants.CONFIG_IO.clearConfig();
        this.loadSettings();
    }

    private void loadSettings() {
        this.fadeTimeEditBox.setValue("" + Constants.CONFIG_IO.getGeneralConfig().getFadeTime());
        this.breakTimeEditBox.setValue("" + Constants.CONFIG_IO.getGeneralConfig().getBreakTime());
    }

    @Override
    public void onClose() {
        try {
            Constants.CONFIG_IO.getGeneralConfig().setBreakTime(Integer.parseInt(this.breakTimeEditBox.getValue()));
        }
        catch (NumberFormatException e) {
            Constants.CONFIG_IO.getGeneralConfig().setDefaultBreakTime();
        }
        try {
            Constants.CONFIG_IO.getGeneralConfig().setFadeTime(Integer.parseInt(this.fadeTimeEditBox.getValue()));
        }
        catch (NumberFormatException e) {
            Constants.CONFIG_IO.getGeneralConfig().setDefaultFadeTime();
        }
        this.configScreen.returnToThisScreen();
    }
}

