/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.BiomeCondition;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionManager;
import io.github.maki99999.biomebeats.condition.TagCondition;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.service.Services;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class DebugHud {
    private static final int LINE_SPACING = 10;
    private static final int X_GLOBAL_OFFSET = 4;
    private static final int SMALL_OFFSET = 4;
    private static final int Y_PADDING = 2;
    private static final int Y_OFFSET = 4;
    public static boolean enabled = Services.PLATFORM.isDevelopmentEnvironment();

    public static void onRenderHUD(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92062_ || !enabled) {
            return;
        }
        Collection<Condition> conditions = Constants.CONDITION_MANAGER.getConditions();
        List<Condition> activeConditions = conditions.stream().filter(Condition::isConditionMet).toList();
        DebugHud.drawConditions(guiGraphics, font, conditions, activeConditions);
        DebugHud.drawMusicPlayerInfo(guiGraphics, font);
        DebugHud.drawMusicTracks(guiGraphics, font, activeConditions);
    }

    private static void drawMusicPlayerInfo(GuiGraphics guiGraphics, Font font) {
        AtomicInteger y = new AtomicInteger(4);
        String text = Constants.MUSIC_MANAGER.getDebugString1();
        int width = font.m_92895_(text);
        guiGraphics.m_280488_(font, text, guiGraphics.m_280182_() - width - 4, y.get(), BiomeBeatsColor.WHITE.getHex());
        y.addAndGet(10);
        text = Constants.MUSIC_MANAGER.getDebugString2();
        width = font.m_92895_(text);
        guiGraphics.m_280488_(font, text, guiGraphics.m_280182_() - width - 4, y.get(), BiomeBeatsColor.WHITE.getHex());
    }

    private static void drawMusicTracks(GuiGraphics guiGraphics, Font font, Collection<Condition> activeConditions) {
        AtomicInteger y = new AtomicInteger(28);
        MusicTrack currentTrack = Constants.MUSIC_MANAGER.getCurrentMusicTrack();
        for (MusicTrack musicTrack : Constants.CONDITION_MUSIC_MANAGER.getTracksFromActiveConditions(activeConditions).stream().sorted(Comparator.comparing(x -> x != currentTrack)).toList()) {
            String text = musicTrack.getName();
            int width = font.m_92895_(text);
            guiGraphics.m_280488_(font, text, guiGraphics.m_280182_() - width - 4, y.get(), (musicTrack == currentTrack ? BiomeBeatsColor.BLUE : BiomeBeatsColor.WHITE).getHex());
            y.addAndGet(10);
        }
    }

    private static void drawConditions(GuiGraphics guiGraphics, Font font, Collection<Condition> allConditions, Collection<Condition> activeConditions) {
        AtomicInteger y = new AtomicInteger(4);
        int maxPriority = Constants.CONDITION_MUSIC_MANAGER.getHighestPriorityOfConditionsWithMusicTracks(activeConditions);
        List<CombinedCondition> combinedConditions = allConditions.stream().filter(x -> x instanceof CombinedCondition).map(x -> (CombinedCondition)x).toList();
        List<Condition> biomeConditions = activeConditions.stream().filter(x -> x instanceof BiomeCondition).toList();
        List<Condition> inactiveBiomeConditions = allConditions.stream().filter(x -> x instanceof BiomeCondition && !x.isConditionMet()).toList();
        List<Condition> biomeTagConditions = activeConditions.stream().filter(x -> x instanceof TagCondition).toList();
        List<Condition> inactiveBiomeTagConditions = allConditions.stream().filter(x -> x instanceof TagCondition && !x.isConditionMet()).toList();
        List<Condition> otherConditions = activeConditions.stream().filter(x -> !(x instanceof TagCondition) && !(x instanceof CombinedCondition) && !(x instanceof BiomeCondition)).toList();
        List<Condition> inactiveOtherConditions = allConditions.stream().filter(x -> !(x instanceof TagCondition) && !(x instanceof CombinedCondition) && !(x instanceof BiomeCondition) && !x.isConditionMet()).toList();
        for (CombinedCondition combinedCondition : combinedConditions) {
            int color = (combinedCondition.getPriority() == maxPriority ? BiomeBeatsColor.BLUE : BiomeBeatsColor.WHITE).getHex();
            guiGraphics.m_280488_(font, "%s [%d] %s".formatted(combinedCondition.isConditionMet() ? "\u2714" : "\u2716", combinedCondition.getPriority(), combinedCondition.getName()), 4, y.get(), color);
            y.addAndGet(10);
            combinedCondition.getConditionIds().stream().map(ConditionManager::getCondition).sorted(Comparator.comparing(c -> c == null ? "" : c.getName()).reversed()).forEach(c -> {
                if (c == null) {
                    guiGraphics.m_280488_(font, "? [?] <unknown>", 8, y.get(), color);
                } else {
                    guiGraphics.m_280488_(font, "%s [%d] %s".formatted(c.isConditionMet() ? "\u2714" : "\u2716", c.getPriority(), c.getName()), 8, y.get(), color);
                }
                y.addAndGet(10);
            });
        }
        y.addAndGet(4);
        DebugHud.drawConditionList(guiGraphics, biomeConditions, font, y, 4, maxPriority);
        DebugHud.drawConditionList(guiGraphics, biomeTagConditions, font, y, 8, maxPriority);
        guiGraphics.m_280488_(font, "\u2716 %d inactive Biome Conditions,".formatted(inactiveBiomeConditions.size()), 4, y.get(), BiomeBeatsColor.WHITE.getHex());
        y.addAndGet(10);
        guiGraphics.m_280488_(font, "    %d inactive Tag Conditions".formatted(inactiveBiomeTagConditions.size()), 4, y.get(), BiomeBeatsColor.WHITE.getHex());
        y.addAndGet(14);
        DebugHud.drawConditionList(guiGraphics, otherConditions, font, y, 4, maxPriority);
        guiGraphics.m_280488_(font, "\u2716 %d inactive Other Conditions".formatted(inactiveOtherConditions.size()), 4, y.get(), BiomeBeatsColor.WHITE.getHex());
    }

    private static void drawConditionList(GuiGraphics guiGraphics, Collection<Condition> conditions, Font font, AtomicInteger y, int x, int maxPriority) {
        conditions.stream().sorted(Comparator.comparing(Condition::getPriority).reversed()).forEach(condition -> {
            String priorityString = condition.getPriority() == Integer.MIN_VALUE ? "-\u221e" : "%d".formatted(condition.getPriority());
            guiGraphics.m_280488_(font, "\u2714 [%s] %s".formatted(priorityString, condition.getName()), x, y.get(), condition.getPriority() == maxPriority ? BiomeBeatsColor.BLUE.getHex() : BiomeBeatsColor.WHITE.getHex());
            y.addAndGet(10);
        });
    }
}

